<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDocumentTypeProfileValuesEC StructType
 * @subpackage Structs
 */
class GetDocumentTypeProfileValuesEC extends AbstractStructBase
{
    /**
     * The documentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentID;
    /**
     * The documentTypeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $documentTypeID;
    /**
     * Constructor method for getDocumentTypeProfileValuesEC
     * @uses GetDocumentTypeProfileValuesEC::setDocumentID()
     * @uses GetDocumentTypeProfileValuesEC::setDocumentTypeID()
     * @param int $documentID
     * @param int $documentTypeID
     */
    public function __construct($documentID = null, $documentTypeID = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setDocumentTypeID($documentTypeID);
    }
    /**
     * Get documentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->documentID;
    }
    /**
     * Set documentID value
     * @param int $documentID
     * @return \StructType\GetDocumentTypeProfileValuesEC
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->documentID = $documentID;
        return $this;
    }
    /**
     * Get documentTypeID value
     * @return int
     */
    public function getDocumentTypeID()
    {
        return $this->documentTypeID;
    }
    /**
     * Set documentTypeID value
     * @param int $documentTypeID
     * @return \StructType\GetDocumentTypeProfileValuesEC
     */
    public function setDocumentTypeID($documentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($documentTypeID) && !(is_int($documentTypeID) || ctype_digit($documentTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentTypeID, true), gettype($documentTypeID)), __LINE__);
        }
        $this->documentTypeID = $documentTypeID;
        return $this;
    }
}
