<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentTypeProfileValue StructType
 * @subpackage Structs
 */
class DocumentTypeProfileValue extends AbstractStructBase
{
    /**
     * The DocumentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentID;
    /**
     * The ProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProfileID;
    /**
     * The IsMust
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsMust;
    /**
     * The SizeOfValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SizeOfValue;
    /**
     * The ProfileValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileValue;
    /**
     * The ProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileName;
    /**
     * The ProfileType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileType;
    /**
     * The ProfileCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileCode;
    /**
     * Constructor method for DocumentTypeProfileValue
     * @uses DocumentTypeProfileValue::setDocumentID()
     * @uses DocumentTypeProfileValue::setProfileID()
     * @uses DocumentTypeProfileValue::setIsMust()
     * @uses DocumentTypeProfileValue::setSizeOfValue()
     * @uses DocumentTypeProfileValue::setProfileValue()
     * @uses DocumentTypeProfileValue::setProfileName()
     * @uses DocumentTypeProfileValue::setProfileType()
     * @uses DocumentTypeProfileValue::setProfileCode()
     * @param int $documentID
     * @param int $profileID
     * @param int $isMust
     * @param int $sizeOfValue
     * @param string $profileValue
     * @param string $profileName
     * @param string $profileType
     * @param string $profileCode
     */
    public function __construct($documentID = null, $profileID = null, $isMust = null, $sizeOfValue = null, $profileValue = null, $profileName = null, $profileType = null, $profileCode = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setProfileID($profileID)
            ->setIsMust($isMust)
            ->setSizeOfValue($sizeOfValue)
            ->setProfileValue($profileValue)
            ->setProfileName($profileName)
            ->setProfileType($profileType)
            ->setProfileCode($profileCode);
    }
    /**
     * Get DocumentID value
     * @return int
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param int $documentID
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setDocumentID($documentID = null)
    {
        // validation for constraint: int
        if (!is_null($documentID) && !(is_int($documentID) || ctype_digit($documentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentID, true), gettype($documentID)), __LINE__);
        }
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get IsMust value
     * @return int
     */
    public function getIsMust()
    {
        return $this->IsMust;
    }
    /**
     * Set IsMust value
     * @param int $isMust
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setIsMust($isMust = null)
    {
        // validation for constraint: int
        if (!is_null($isMust) && !(is_int($isMust) || ctype_digit($isMust))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isMust, true), gettype($isMust)), __LINE__);
        }
        $this->IsMust = $isMust;
        return $this;
    }
    /**
     * Get SizeOfValue value
     * @return int
     */
    public function getSizeOfValue()
    {
        return $this->SizeOfValue;
    }
    /**
     * Set SizeOfValue value
     * @param int $sizeOfValue
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setSizeOfValue($sizeOfValue = null)
    {
        // validation for constraint: int
        if (!is_null($sizeOfValue) && !(is_int($sizeOfValue) || ctype_digit($sizeOfValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeOfValue, true), gettype($sizeOfValue)), __LINE__);
        }
        $this->SizeOfValue = $sizeOfValue;
        return $this;
    }
    /**
     * Get ProfileValue value
     * @return string|null
     */
    public function getProfileValue()
    {
        return $this->ProfileValue;
    }
    /**
     * Set ProfileValue value
     * @param string $profileValue
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setProfileValue($profileValue = null)
    {
        // validation for constraint: string
        if (!is_null($profileValue) && !is_string($profileValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileValue, true), gettype($profileValue)), __LINE__);
        }
        $this->ProfileValue = $profileValue;
        return $this;
    }
    /**
     * Get ProfileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->ProfileName;
    }
    /**
     * Set ProfileName value
     * @param string $profileName
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileName, true), gettype($profileName)), __LINE__);
        }
        $this->ProfileName = $profileName;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return string|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param string $profileType
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: string
        if (!is_null($profileType) && !is_string($profileType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get ProfileCode value
     * @return string|null
     */
    public function getProfileCode()
    {
        return $this->ProfileCode;
    }
    /**
     * Set ProfileCode value
     * @param string $profileCode
     * @return \StructType\DocumentTypeProfileValue
     */
    public function setProfileCode($profileCode = null)
    {
        // validation for constraint: string
        if (!is_null($profileCode) && !is_string($profileCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileCode, true), gettype($profileCode)), __LINE__);
        }
        $this->ProfileCode = $profileCode;
        return $this;
    }
}
