<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArchiveStore StructType
 * @subpackage Structs
 */
class ArchiveStore extends AbstractStructBase
{
    /**
     * The ElementID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ElementID;
    /**
     * The ElementType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ElementType;
    /**
     * The ClearanceType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClearanceType;
    /**
     * The StoreCriteria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreCriteria;
    /**
     * The StoreDuration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreDuration;
    /**
     * The StoreType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreType;
    /**
     * The PrivacyDegree
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrivacyDegree;
    /**
     * Constructor method for ArchiveStore
     * @uses ArchiveStore::setElementID()
     * @uses ArchiveStore::setElementType()
     * @uses ArchiveStore::setClearanceType()
     * @uses ArchiveStore::setStoreCriteria()
     * @uses ArchiveStore::setStoreDuration()
     * @uses ArchiveStore::setStoreType()
     * @uses ArchiveStore::setPrivacyDegree()
     * @param int $elementID
     * @param int $elementType
     * @param string $clearanceType
     * @param string $storeCriteria
     * @param string $storeDuration
     * @param string $storeType
     * @param string $privacyDegree
     */
    public function __construct($elementID = null, $elementType = null, $clearanceType = null, $storeCriteria = null, $storeDuration = null, $storeType = null, $privacyDegree = null)
    {
        $this
            ->setElementID($elementID)
            ->setElementType($elementType)
            ->setClearanceType($clearanceType)
            ->setStoreCriteria($storeCriteria)
            ->setStoreDuration($storeDuration)
            ->setStoreType($storeType)
            ->setPrivacyDegree($privacyDegree);
    }
    /**
     * Get ElementID value
     * @return int
     */
    public function getElementID()
    {
        return $this->ElementID;
    }
    /**
     * Set ElementID value
     * @param int $elementID
     * @return \StructType\ArchiveStore
     */
    public function setElementID($elementID = null)
    {
        // validation for constraint: int
        if (!is_null($elementID) && !(is_int($elementID) || ctype_digit($elementID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elementID, true), gettype($elementID)), __LINE__);
        }
        $this->ElementID = $elementID;
        return $this;
    }
    /**
     * Get ElementType value
     * @return int
     */
    public function getElementType()
    {
        return $this->ElementType;
    }
    /**
     * Set ElementType value
     * @param int $elementType
     * @return \StructType\ArchiveStore
     */
    public function setElementType($elementType = null)
    {
        // validation for constraint: int
        if (!is_null($elementType) && !(is_int($elementType) || ctype_digit($elementType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elementType, true), gettype($elementType)), __LINE__);
        }
        $this->ElementType = $elementType;
        return $this;
    }
    /**
     * Get ClearanceType value
     * @return string|null
     */
    public function getClearanceType()
    {
        return $this->ClearanceType;
    }
    /**
     * Set ClearanceType value
     * @param string $clearanceType
     * @return \StructType\ArchiveStore
     */
    public function setClearanceType($clearanceType = null)
    {
        // validation for constraint: string
        if (!is_null($clearanceType) && !is_string($clearanceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearanceType, true), gettype($clearanceType)), __LINE__);
        }
        $this->ClearanceType = $clearanceType;
        return $this;
    }
    /**
     * Get StoreCriteria value
     * @return string|null
     */
    public function getStoreCriteria()
    {
        return $this->StoreCriteria;
    }
    /**
     * Set StoreCriteria value
     * @param string $storeCriteria
     * @return \StructType\ArchiveStore
     */
    public function setStoreCriteria($storeCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($storeCriteria) && !is_string($storeCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeCriteria, true), gettype($storeCriteria)), __LINE__);
        }
        $this->StoreCriteria = $storeCriteria;
        return $this;
    }
    /**
     * Get StoreDuration value
     * @return string|null
     */
    public function getStoreDuration()
    {
        return $this->StoreDuration;
    }
    /**
     * Set StoreDuration value
     * @param string $storeDuration
     * @return \StructType\ArchiveStore
     */
    public function setStoreDuration($storeDuration = null)
    {
        // validation for constraint: string
        if (!is_null($storeDuration) && !is_string($storeDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeDuration, true), gettype($storeDuration)), __LINE__);
        }
        $this->StoreDuration = $storeDuration;
        return $this;
    }
    /**
     * Get StoreType value
     * @return string|null
     */
    public function getStoreType()
    {
        return $this->StoreType;
    }
    /**
     * Set StoreType value
     * @param string $storeType
     * @return \StructType\ArchiveStore
     */
    public function setStoreType($storeType = null)
    {
        // validation for constraint: string
        if (!is_null($storeType) && !is_string($storeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeType, true), gettype($storeType)), __LINE__);
        }
        $this->StoreType = $storeType;
        return $this;
    }
    /**
     * Get PrivacyDegree value
     * @return string|null
     */
    public function getPrivacyDegree()
    {
        return $this->PrivacyDegree;
    }
    /**
     * Set PrivacyDegree value
     * @param string $privacyDegree
     * @return \StructType\ArchiveStore
     */
    public function setPrivacyDegree($privacyDegree = null)
    {
        // validation for constraint: string
        if (!is_null($privacyDegree) && !is_string($privacyDegree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyDegree, true), gettype($privacyDegree)), __LINE__);
        }
        $this->PrivacyDegree = $privacyDegree;
        return $this;
    }
}
