<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obs ServiceType
 * @subpackage Services
 */
class Obs extends AbstractSoapClientBase
{
    /**
     * Sets the AuthCredential SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthCredential $authCredential
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthCredential(\StructType\AuthCredential $authCredential, $nameSpace = 'http://ebys.bivent.com.tr/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthCredential', $authCredential, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ObsToEbysBelgeOlustur
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObsToEbysBelgeOlustur $parameters
     * @return \StructType\ObsToEbysBelgeOlusturResponse|bool
     */
    public function ObsToEbysBelgeOlustur(\StructType\ObsToEbysBelgeOlustur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObsToEbysBelgeOlustur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObsToEbysBelgeSorgula
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObsToEbysBelgeSorgula $parameters
     * @return \StructType\ObsToEbysBelgeSorgulaResponse|bool
     */
    public function ObsToEbysBelgeSorgula(\StructType\ObsToEbysBelgeSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObsToEbysBelgeSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObsToEbysBelgeOlusturResponse|\StructType\ObsToEbysBelgeSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
