<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for JMOBISE ServiceType
 * @subpackage Services
 */
class JMOBISE extends AbstractSoapClientBase
{
    /**
     * Sets the AuthCredential SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthCredential $authCredential
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthCredential(\StructType\AuthCredential $authCredential, $nameSpace = 'http://ebys.bivent.com.tr/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthCredential', $authCredential, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named JMOBISEvrakLogSorgula
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\JMOBISEvrakLogSorgula $parameters
     * @return \StructType\JMOBISEvrakLogSorgulaResponse|bool
     */
    public function JMOBISEvrakLogSorgula(\StructType\JMOBISEvrakLogSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->JMOBISEvrakLogSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named JMOBISEvrakSorgula
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\JMOBISEvrakSorgula $parameters
     * @return \StructType\JMOBISEvrakSorgulaResponse|bool
     */
    public function JMOBISEvrakSorgula(\StructType\JMOBISEvrakSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->JMOBISEvrakSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\JMOBISEvrakLogSorgulaResponse|\StructType\JMOBISEvrakSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
