<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for DEUT ServiceType
 * @subpackage Services
 */
class DEUT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DEUToEbysBelgeOlustur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DEUToEbysBelgeOlustur $parameters
     * @return \StructType\DEUToEbysBelgeOlusturResponse|bool
     */
    public function DEUToEbysBelgeOlustur(\StructType\DEUToEbysBelgeOlustur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DEUToEbysBelgeOlustur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DEUToEbysBelgeSorgula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DEUToEbysBelgeSorgula $parameters
     * @return \StructType\DEUToEbysBelgeSorgulaResponse|bool
     */
    public function DEUToEbysBelgeSorgula(\StructType\DEUToEbysBelgeSorgula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DEUToEbysBelgeSorgula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DEUToEbysBelgeOlusturResponse|\StructType\DEUToEbysBelgeSorgulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
