<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Sets the AuthCredential SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthCredential $authCredential
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthCredential(\StructType\AuthCredential $authCredential, $nameSpace = 'http://ebys.bivent.com.tr/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthCredential', $authCredential, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddDocument
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDocument $parameters
     * @return \StructType\AddDocumentResponse|bool
     */
    public function AddDocument(\StructType\AddDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDtvtGS
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDtvtGS $parameters
     * @return \StructType\AddDtvtGSResponse|bool
     */
    public function AddDtvtGS(\StructType\AddDtvtGS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddDtvtGS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddDocumentResponse|\StructType\AddDtvtGSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
