<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnreadDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfUnreadDocument extends AbstractStructArrayBase
{
    /**
     * The UnreadDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnreadDocument[]
     */
    public $UnreadDocument;
    /**
     * Constructor method for ArrayOfUnreadDocument
     * @uses ArrayOfUnreadDocument::setUnreadDocument()
     * @param \StructType\UnreadDocument[] $unreadDocument
     */
    public function __construct(array $unreadDocument = array())
    {
        $this
            ->setUnreadDocument($unreadDocument);
    }
    /**
     * Get UnreadDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnreadDocument[]|null
     */
    public function getUnreadDocument()
    {
        return isset($this->UnreadDocument) ? $this->UnreadDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUnreadDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnreadDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnreadDocumentForArrayConstraintsFromSetUnreadDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfUnreadDocumentUnreadDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnreadDocumentUnreadDocumentItem instanceof \StructType\UnreadDocument) {
                $invalidValues[] = is_object($arrayOfUnreadDocumentUnreadDocumentItem) ? get_class($arrayOfUnreadDocumentUnreadDocumentItem) : sprintf('%s(%s)', gettype($arrayOfUnreadDocumentUnreadDocumentItem), var_export($arrayOfUnreadDocumentUnreadDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnreadDocument property can only contain items of type \StructType\UnreadDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnreadDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnreadDocument[] $unreadDocument
     * @return \ArrayType\ArrayOfUnreadDocument
     */
    public function setUnreadDocument(array $unreadDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($unreadDocumentArrayErrorMessage = self::validateUnreadDocumentForArrayConstraintsFromSetUnreadDocument($unreadDocument))) {
            throw new \InvalidArgumentException($unreadDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($unreadDocument) || (is_array($unreadDocument) && empty($unreadDocument))) {
            unset($this->UnreadDocument);
        } else {
            $this->UnreadDocument = $unreadDocument;
        }
        return $this;
    }
    /**
     * Add item to UnreadDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\UnreadDocument $item
     * @return \ArrayType\ArrayOfUnreadDocument
     */
    public function addToUnreadDocument(\StructType\UnreadDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnreadDocument) {
            throw new \InvalidArgumentException(sprintf('The UnreadDocument property can only contain items of type \StructType\UnreadDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnreadDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UnreadDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UnreadDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UnreadDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UnreadDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UnreadDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UnreadDocument
     */
    public function getAttributeName()
    {
        return 'UnreadDocument';
    }
}
