<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSignDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfSignDocument extends AbstractStructArrayBase
{
    /**
     * The SignDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SignDocument[]
     */
    public $SignDocument;
    /**
     * Constructor method for ArrayOfSignDocument
     * @uses ArrayOfSignDocument::setSignDocument()
     * @param \StructType\SignDocument[] $signDocument
     */
    public function __construct(array $signDocument = array())
    {
        $this
            ->setSignDocument($signDocument);
    }
    /**
     * Get SignDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SignDocument[]|null
     */
    public function getSignDocument()
    {
        return isset($this->SignDocument) ? $this->SignDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSignDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignDocumentForArrayConstraintsFromSetSignDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSignDocumentSignDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfSignDocumentSignDocumentItem instanceof \StructType\SignDocument) {
                $invalidValues[] = is_object($arrayOfSignDocumentSignDocumentItem) ? get_class($arrayOfSignDocumentSignDocumentItem) : sprintf('%s(%s)', gettype($arrayOfSignDocumentSignDocumentItem), var_export($arrayOfSignDocumentSignDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SignDocument property can only contain items of type \StructType\SignDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SignDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SignDocument[] $signDocument
     * @return \ArrayType\ArrayOfSignDocument
     */
    public function setSignDocument(array $signDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($signDocumentArrayErrorMessage = self::validateSignDocumentForArrayConstraintsFromSetSignDocument($signDocument))) {
            throw new \InvalidArgumentException($signDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($signDocument) || (is_array($signDocument) && empty($signDocument))) {
            unset($this->SignDocument);
        } else {
            $this->SignDocument = $signDocument;
        }
        return $this;
    }
    /**
     * Add item to SignDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\SignDocument $item
     * @return \ArrayType\ArrayOfSignDocument
     */
    public function addToSignDocument(\StructType\SignDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SignDocument) {
            throw new \InvalidArgumentException(sprintf('The SignDocument property can only contain items of type \StructType\SignDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SignDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SignDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SignDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SignDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SignDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SignDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SignDocument
     */
    public function getAttributeName()
    {
        return 'SignDocument';
    }
}
