<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceObject ArrayType
 * @subpackage Arrays
 */
class ArrayOfServiceObject extends AbstractStructArrayBase
{
    /**
     * The ServiceObject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ServiceObject[]
     */
    public $ServiceObject;
    /**
     * Constructor method for ArrayOfServiceObject
     * @uses ArrayOfServiceObject::setServiceObject()
     * @param \StructType\ServiceObject[] $serviceObject
     */
    public function __construct(array $serviceObject = array())
    {
        $this
            ->setServiceObject($serviceObject);
    }
    /**
     * Get ServiceObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceObject[]|null
     */
    public function getServiceObject()
    {
        return isset($this->ServiceObject) ? $this->ServiceObject : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceObjectForArrayConstraintsFromSetServiceObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceObjectServiceObjectItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceObjectServiceObjectItem instanceof \StructType\ServiceObject) {
                $invalidValues[] = is_object($arrayOfServiceObjectServiceObjectItem) ? get_class($arrayOfServiceObjectServiceObjectItem) : sprintf('%s(%s)', gettype($arrayOfServiceObjectServiceObjectItem), var_export($arrayOfServiceObjectServiceObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceObject property can only contain items of type \StructType\ServiceObject, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceObject[] $serviceObject
     * @return \ArrayType\ArrayOfServiceObject
     */
    public function setServiceObject(array $serviceObject = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceObjectArrayErrorMessage = self::validateServiceObjectForArrayConstraintsFromSetServiceObject($serviceObject))) {
            throw new \InvalidArgumentException($serviceObjectArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceObject) || (is_array($serviceObject) && empty($serviceObject))) {
            unset($this->ServiceObject);
        } else {
            $this->ServiceObject = $serviceObject;
        }
        return $this;
    }
    /**
     * Add item to ServiceObject value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceObject $item
     * @return \ArrayType\ArrayOfServiceObject
     */
    public function addToServiceObject(\StructType\ServiceObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceObject) {
            throw new \InvalidArgumentException(sprintf('The ServiceObject property can only contain items of type \StructType\ServiceObject, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceObject[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceObject|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceObject|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceObject|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceObject|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceObject|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceObject
     */
    public function getAttributeName()
    {
        return 'ServiceObject';
    }
}
