<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJMODocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfJMODocument extends AbstractStructArrayBase
{
    /**
     * The JMODocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JMODocument[]
     */
    public $JMODocument;
    /**
     * Constructor method for ArrayOfJMODocument
     * @uses ArrayOfJMODocument::setJMODocument()
     * @param \StructType\JMODocument[] $jMODocument
     */
    public function __construct(array $jMODocument = array())
    {
        $this
            ->setJMODocument($jMODocument);
    }
    /**
     * Get JMODocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JMODocument[]|null
     */
    public function getJMODocument()
    {
        return isset($this->JMODocument) ? $this->JMODocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setJMODocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJMODocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJMODocumentForArrayConstraintsFromSetJMODocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJMODocumentJMODocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJMODocumentJMODocumentItem instanceof \StructType\JMODocument) {
                $invalidValues[] = is_object($arrayOfJMODocumentJMODocumentItem) ? get_class($arrayOfJMODocumentJMODocumentItem) : sprintf('%s(%s)', gettype($arrayOfJMODocumentJMODocumentItem), var_export($arrayOfJMODocumentJMODocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JMODocument property can only contain items of type \StructType\JMODocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JMODocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JMODocument[] $jMODocument
     * @return \ArrayType\ArrayOfJMODocument
     */
    public function setJMODocument(array $jMODocument = array())
    {
        // validation for constraint: array
        if ('' !== ($jMODocumentArrayErrorMessage = self::validateJMODocumentForArrayConstraintsFromSetJMODocument($jMODocument))) {
            throw new \InvalidArgumentException($jMODocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($jMODocument) || (is_array($jMODocument) && empty($jMODocument))) {
            unset($this->JMODocument);
        } else {
            $this->JMODocument = $jMODocument;
        }
        return $this;
    }
    /**
     * Add item to JMODocument value
     * @throws \InvalidArgumentException
     * @param \StructType\JMODocument $item
     * @return \ArrayType\ArrayOfJMODocument
     */
    public function addToJMODocument(\StructType\JMODocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JMODocument) {
            throw new \InvalidArgumentException(sprintf('The JMODocument property can only contain items of type \StructType\JMODocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JMODocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JMODocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JMODocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JMODocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JMODocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JMODocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JMODocument
     */
    public function getAttributeName()
    {
        return 'JMODocument';
    }
}
