<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAppendix ArrayType
 * @subpackage Arrays
 */
class ArrayOfAppendix extends AbstractStructArrayBase
{
    /**
     * The Appendix
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Appendix[]
     */
    public $Appendix;
    /**
     * Constructor method for ArrayOfAppendix
     * @uses ArrayOfAppendix::setAppendix()
     * @param \StructType\Appendix[] $appendix
     */
    public function __construct(array $appendix = array())
    {
        $this
            ->setAppendix($appendix);
    }
    /**
     * Get Appendix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Appendix[]|null
     */
    public function getAppendix()
    {
        return isset($this->Appendix) ? $this->Appendix : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAppendix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAppendix method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAppendixForArrayConstraintsFromSetAppendix(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAppendixAppendixItem) {
            // validation for constraint: itemType
            if (!$arrayOfAppendixAppendixItem instanceof \StructType\Appendix) {
                $invalidValues[] = is_object($arrayOfAppendixAppendixItem) ? get_class($arrayOfAppendixAppendixItem) : sprintf('%s(%s)', gettype($arrayOfAppendixAppendixItem), var_export($arrayOfAppendixAppendixItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Appendix property can only contain items of type \StructType\Appendix, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Appendix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Appendix[] $appendix
     * @return \ArrayType\ArrayOfAppendix
     */
    public function setAppendix(array $appendix = array())
    {
        // validation for constraint: array
        if ('' !== ($appendixArrayErrorMessage = self::validateAppendixForArrayConstraintsFromSetAppendix($appendix))) {
            throw new \InvalidArgumentException($appendixArrayErrorMessage, __LINE__);
        }
        if (is_null($appendix) || (is_array($appendix) && empty($appendix))) {
            unset($this->Appendix);
        } else {
            $this->Appendix = $appendix;
        }
        return $this;
    }
    /**
     * Add item to Appendix value
     * @throws \InvalidArgumentException
     * @param \StructType\Appendix $item
     * @return \ArrayType\ArrayOfAppendix
     */
    public function addToAppendix(\StructType\Appendix $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Appendix) {
            throw new \InvalidArgumentException(sprintf('The Appendix property can only contain items of type \StructType\Appendix, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Appendix[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Appendix|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Appendix|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Appendix|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Appendix|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Appendix|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Appendix
     */
    public function getAttributeName()
    {
        return 'Appendix';
    }
}
