<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleDocument StructType
 * @subpackage Structs
 */
class SimpleDocument extends AbstractStructBase
{
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentType;
    /**
     * The DocumentLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentLanguage;
    /**
     * The WorkFlow
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WorkFlow;
    /**
     * The EmergencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EmergencyID;
    /**
     * The OwnerFolderOID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerFolderOID;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileData;
    /**
     * The FileExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileExtension;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentName;
    /**
     * Constructor method for SimpleDocument
     * @uses SimpleDocument::setDocumentType()
     * @uses SimpleDocument::setDocumentLanguage()
     * @uses SimpleDocument::setWorkFlow()
     * @uses SimpleDocument::setEmergencyID()
     * @uses SimpleDocument::setOwnerFolderOID()
     * @uses SimpleDocument::setFileData()
     * @uses SimpleDocument::setFileExtension()
     * @uses SimpleDocument::setDocumentName()
     * @param int $documentType
     * @param int $documentLanguage
     * @param int $workFlow
     * @param int $emergencyID
     * @param int $ownerFolderOID
     * @param string $fileData
     * @param string $fileExtension
     * @param string $documentName
     */
    public function __construct($documentType = null, $documentLanguage = null, $workFlow = null, $emergencyID = null, $ownerFolderOID = null, $fileData = null, $fileExtension = null, $documentName = null)
    {
        $this
            ->setDocumentType($documentType)
            ->setDocumentLanguage($documentLanguage)
            ->setWorkFlow($workFlow)
            ->setEmergencyID($emergencyID)
            ->setOwnerFolderOID($ownerFolderOID)
            ->setFileData($fileData)
            ->setFileExtension($fileExtension)
            ->setDocumentName($documentName);
    }
    /**
     * Get DocumentType value
     * @return int
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param int $documentType
     * @return \StructType\SimpleDocument
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: int
        if (!is_null($documentType) && !(is_int($documentType) || ctype_digit($documentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get DocumentLanguage value
     * @return int
     */
    public function getDocumentLanguage()
    {
        return $this->DocumentLanguage;
    }
    /**
     * Set DocumentLanguage value
     * @param int $documentLanguage
     * @return \StructType\SimpleDocument
     */
    public function setDocumentLanguage($documentLanguage = null)
    {
        // validation for constraint: int
        if (!is_null($documentLanguage) && !(is_int($documentLanguage) || ctype_digit($documentLanguage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentLanguage, true), gettype($documentLanguage)), __LINE__);
        }
        $this->DocumentLanguage = $documentLanguage;
        return $this;
    }
    /**
     * Get WorkFlow value
     * @return int
     */
    public function getWorkFlow()
    {
        return $this->WorkFlow;
    }
    /**
     * Set WorkFlow value
     * @param int $workFlow
     * @return \StructType\SimpleDocument
     */
    public function setWorkFlow($workFlow = null)
    {
        // validation for constraint: int
        if (!is_null($workFlow) && !(is_int($workFlow) || ctype_digit($workFlow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($workFlow, true), gettype($workFlow)), __LINE__);
        }
        $this->WorkFlow = $workFlow;
        return $this;
    }
    /**
     * Get EmergencyID value
     * @return int
     */
    public function getEmergencyID()
    {
        return $this->EmergencyID;
    }
    /**
     * Set EmergencyID value
     * @param int $emergencyID
     * @return \StructType\SimpleDocument
     */
    public function setEmergencyID($emergencyID = null)
    {
        // validation for constraint: int
        if (!is_null($emergencyID) && !(is_int($emergencyID) || ctype_digit($emergencyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emergencyID, true), gettype($emergencyID)), __LINE__);
        }
        $this->EmergencyID = $emergencyID;
        return $this;
    }
    /**
     * Get OwnerFolderOID value
     * @return int
     */
    public function getOwnerFolderOID()
    {
        return $this->OwnerFolderOID;
    }
    /**
     * Set OwnerFolderOID value
     * @param int $ownerFolderOID
     * @return \StructType\SimpleDocument
     */
    public function setOwnerFolderOID($ownerFolderOID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerFolderOID) && !(is_int($ownerFolderOID) || ctype_digit($ownerFolderOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerFolderOID, true), gettype($ownerFolderOID)), __LINE__);
        }
        $this->OwnerFolderOID = $ownerFolderOID;
        return $this;
    }
    /**
     * Get FileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->FileData;
    }
    /**
     * Set FileData value
     * @param string $fileData
     * @return \StructType\SimpleDocument
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        $this->FileData = $fileData;
        return $this;
    }
    /**
     * Get FileExtension value
     * @return string|null
     */
    public function getFileExtension()
    {
        return $this->FileExtension;
    }
    /**
     * Set FileExtension value
     * @param string $fileExtension
     * @return \StructType\SimpleDocument
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        $this->FileExtension = $fileExtension;
        return $this;
    }
    /**
     * Get DocumentName value
     * @return string|null
     */
    public function getDocumentName()
    {
        return $this->DocumentName;
    }
    /**
     * Set DocumentName value
     * @param string $documentName
     * @return \StructType\SimpleDocument
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        $this->DocumentName = $documentName;
        return $this;
    }
}
