<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceUserInfo StructType
 * @subpackage Structs
 */
class ServiceUserInfo extends AbstractStructBase
{
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The ChairID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChairID;
    /**
     * The UnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitID;
    /**
     * The TCK
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TCK;
    /**
     * The NameSurname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameSurname;
    /**
     * The ChairName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChairName;
    /**
     * The UnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitName;
    /**
     * The UnitCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * Constructor method for ServiceUserInfo
     * @uses ServiceUserInfo::setUserID()
     * @uses ServiceUserInfo::setChairID()
     * @uses ServiceUserInfo::setUnitID()
     * @uses ServiceUserInfo::setTCK()
     * @uses ServiceUserInfo::setNameSurname()
     * @uses ServiceUserInfo::setChairName()
     * @uses ServiceUserInfo::setUnitName()
     * @uses ServiceUserInfo::setUnitCode()
     * @param int $userID
     * @param int $chairID
     * @param int $unitID
     * @param string $tCK
     * @param string $nameSurname
     * @param string $chairName
     * @param string $unitName
     * @param string $unitCode
     */
    public function __construct($userID = null, $chairID = null, $unitID = null, $tCK = null, $nameSurname = null, $chairName = null, $unitName = null, $unitCode = null)
    {
        $this
            ->setUserID($userID)
            ->setChairID($chairID)
            ->setUnitID($unitID)
            ->setTCK($tCK)
            ->setNameSurname($nameSurname)
            ->setChairName($chairName)
            ->setUnitName($unitName)
            ->setUnitCode($unitCode);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\ServiceUserInfo
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get ChairID value
     * @return int
     */
    public function getChairID()
    {
        return $this->ChairID;
    }
    /**
     * Set ChairID value
     * @param int $chairID
     * @return \StructType\ServiceUserInfo
     */
    public function setChairID($chairID = null)
    {
        // validation for constraint: int
        if (!is_null($chairID) && !(is_int($chairID) || ctype_digit($chairID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chairID, true), gettype($chairID)), __LINE__);
        }
        $this->ChairID = $chairID;
        return $this;
    }
    /**
     * Get UnitID value
     * @return int
     */
    public function getUnitID()
    {
        return $this->UnitID;
    }
    /**
     * Set UnitID value
     * @param int $unitID
     * @return \StructType\ServiceUserInfo
     */
    public function setUnitID($unitID = null)
    {
        // validation for constraint: int
        if (!is_null($unitID) && !(is_int($unitID) || ctype_digit($unitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitID, true), gettype($unitID)), __LINE__);
        }
        $this->UnitID = $unitID;
        return $this;
    }
    /**
     * Get TCK value
     * @return string|null
     */
    public function getTCK()
    {
        return $this->TCK;
    }
    /**
     * Set TCK value
     * @param string $tCK
     * @return \StructType\ServiceUserInfo
     */
    public function setTCK($tCK = null)
    {
        // validation for constraint: string
        if (!is_null($tCK) && !is_string($tCK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCK, true), gettype($tCK)), __LINE__);
        }
        $this->TCK = $tCK;
        return $this;
    }
    /**
     * Get NameSurname value
     * @return string|null
     */
    public function getNameSurname()
    {
        return $this->NameSurname;
    }
    /**
     * Set NameSurname value
     * @param string $nameSurname
     * @return \StructType\ServiceUserInfo
     */
    public function setNameSurname($nameSurname = null)
    {
        // validation for constraint: string
        if (!is_null($nameSurname) && !is_string($nameSurname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameSurname, true), gettype($nameSurname)), __LINE__);
        }
        $this->NameSurname = $nameSurname;
        return $this;
    }
    /**
     * Get ChairName value
     * @return string|null
     */
    public function getChairName()
    {
        return $this->ChairName;
    }
    /**
     * Set ChairName value
     * @param string $chairName
     * @return \StructType\ServiceUserInfo
     */
    public function setChairName($chairName = null)
    {
        // validation for constraint: string
        if (!is_null($chairName) && !is_string($chairName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chairName, true), gettype($chairName)), __LINE__);
        }
        $this->ChairName = $chairName;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\ServiceUserInfo
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\ServiceUserInfo
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
}
