<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceObject StructType
 * @subpackage Structs
 */
class ServiceObject extends AbstractStructBase
{
    /**
     * The IsReadOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReadOnly;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The ScreenName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScreenName;
    /**
     * The RealName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RealName;
    /**
     * The DesignType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesignType;
    /**
     * Constructor method for ServiceObject
     * @uses ServiceObject::setIsReadOnly()
     * @uses ServiceObject::setType()
     * @uses ServiceObject::setScreenName()
     * @uses ServiceObject::setRealName()
     * @uses ServiceObject::setDesignType()
     * @param bool $isReadOnly
     * @param string $type
     * @param string $screenName
     * @param string $realName
     * @param string $designType
     */
    public function __construct($isReadOnly = null, $type = null, $screenName = null, $realName = null, $designType = null)
    {
        $this
            ->setIsReadOnly($isReadOnly)
            ->setType($type)
            ->setScreenName($screenName)
            ->setRealName($realName)
            ->setDesignType($designType);
    }
    /**
     * Get IsReadOnly value
     * @return bool
     */
    public function getIsReadOnly()
    {
        return $this->IsReadOnly;
    }
    /**
     * Set IsReadOnly value
     * @param bool $isReadOnly
     * @return \StructType\ServiceObject
     */
    public function setIsReadOnly($isReadOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReadOnly) && !is_bool($isReadOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReadOnly, true), gettype($isReadOnly)), __LINE__);
        }
        $this->IsReadOnly = $isReadOnly;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ServiceObject
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ScreenName value
     * @return string|null
     */
    public function getScreenName()
    {
        return $this->ScreenName;
    }
    /**
     * Set ScreenName value
     * @param string $screenName
     * @return \StructType\ServiceObject
     */
    public function setScreenName($screenName = null)
    {
        // validation for constraint: string
        if (!is_null($screenName) && !is_string($screenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($screenName, true), gettype($screenName)), __LINE__);
        }
        $this->ScreenName = $screenName;
        return $this;
    }
    /**
     * Get RealName value
     * @return string|null
     */
    public function getRealName()
    {
        return $this->RealName;
    }
    /**
     * Set RealName value
     * @param string $realName
     * @return \StructType\ServiceObject
     */
    public function setRealName($realName = null)
    {
        // validation for constraint: string
        if (!is_null($realName) && !is_string($realName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realName, true), gettype($realName)), __LINE__);
        }
        $this->RealName = $realName;
        return $this;
    }
    /**
     * Get DesignType value
     * @return string|null
     */
    public function getDesignType()
    {
        return $this->DesignType;
    }
    /**
     * Set DesignType value
     * @param string $designType
     * @return \StructType\ServiceObject
     */
    public function setDesignType($designType = null)
    {
        // validation for constraint: string
        if (!is_null($designType) && !is_string($designType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designType, true), gettype($designType)), __LINE__);
        }
        $this->DesignType = $designType;
        return $this;
    }
}
