<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SecurityLevelShortInfo StructType
 * @subpackage Structs
 */
class SecurityLevelShortInfo extends AbstractStructBase
{
    /**
     * The SecurityLevelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SecurityLevelNumber;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The Definition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Definition;
    /**
     * Constructor method for SecurityLevelShortInfo
     * @uses SecurityLevelShortInfo::setSecurityLevelNumber()
     * @uses SecurityLevelShortInfo::setIsDefault()
     * @uses SecurityLevelShortInfo::setDefinition()
     * @param int $securityLevelNumber
     * @param bool $isDefault
     * @param string $definition
     */
    public function __construct($securityLevelNumber = null, $isDefault = null, $definition = null)
    {
        $this
            ->setSecurityLevelNumber($securityLevelNumber)
            ->setIsDefault($isDefault)
            ->setDefinition($definition);
    }
    /**
     * Get SecurityLevelNumber value
     * @return int
     */
    public function getSecurityLevelNumber()
    {
        return $this->SecurityLevelNumber;
    }
    /**
     * Set SecurityLevelNumber value
     * @param int $securityLevelNumber
     * @return \StructType\SecurityLevelShortInfo
     */
    public function setSecurityLevelNumber($securityLevelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($securityLevelNumber) && !(is_int($securityLevelNumber) || ctype_digit($securityLevelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($securityLevelNumber, true), gettype($securityLevelNumber)), __LINE__);
        }
        $this->SecurityLevelNumber = $securityLevelNumber;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\SecurityLevelShortInfo
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get Definition value
     * @return string|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }
    /**
     * Set Definition value
     * @param string $definition
     * @return \StructType\SecurityLevelShortInfo
     */
    public function setDefinition($definition = null)
    {
        // validation for constraint: string
        if (!is_null($definition) && !is_string($definition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definition, true), gettype($definition)), __LINE__);
        }
        $this->Definition = $definition;
        return $this;
    }
}
