<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DTVTUnit StructType
 * @subpackage Structs
 */
class DTVTUnit extends AbstractStructBase
{
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjectID;
    /**
     * The OwnerOID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OwnerOID;
    /**
     * The NoOfChildren
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NoOfChildren;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The WebAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddress;
    /**
     * Constructor method for DTVTUnit
     * @uses DTVTUnit::setObjectID()
     * @uses DTVTUnit::setOwnerOID()
     * @uses DTVTUnit::setNoOfChildren()
     * @uses DTVTUnit::setName()
     * @uses DTVTUnit::setCode()
     * @uses DTVTUnit::setAddress()
     * @uses DTVTUnit::setPhoneNumber()
     * @uses DTVTUnit::setEmail()
     * @uses DTVTUnit::setWebAddress()
     * @param int $objectID
     * @param int $ownerOID
     * @param int $noOfChildren
     * @param string $name
     * @param string $code
     * @param string $address
     * @param string $phoneNumber
     * @param string $email
     * @param string $webAddress
     */
    public function __construct($objectID = null, $ownerOID = null, $noOfChildren = null, $name = null, $code = null, $address = null, $phoneNumber = null, $email = null, $webAddress = null)
    {
        $this
            ->setObjectID($objectID)
            ->setOwnerOID($ownerOID)
            ->setNoOfChildren($noOfChildren)
            ->setName($name)
            ->setCode($code)
            ->setAddress($address)
            ->setPhoneNumber($phoneNumber)
            ->setEmail($email)
            ->setWebAddress($webAddress);
    }
    /**
     * Get ObjectID value
     * @return int
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param int $objectID
     * @return \StructType\DTVTUnit
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get OwnerOID value
     * @return int
     */
    public function getOwnerOID()
    {
        return $this->OwnerOID;
    }
    /**
     * Set OwnerOID value
     * @param int $ownerOID
     * @return \StructType\DTVTUnit
     */
    public function setOwnerOID($ownerOID = null)
    {
        // validation for constraint: int
        if (!is_null($ownerOID) && !(is_int($ownerOID) || ctype_digit($ownerOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ownerOID, true), gettype($ownerOID)), __LINE__);
        }
        $this->OwnerOID = $ownerOID;
        return $this;
    }
    /**
     * Get NoOfChildren value
     * @return int
     */
    public function getNoOfChildren()
    {
        return $this->NoOfChildren;
    }
    /**
     * Set NoOfChildren value
     * @param int $noOfChildren
     * @return \StructType\DTVTUnit
     */
    public function setNoOfChildren($noOfChildren = null)
    {
        // validation for constraint: int
        if (!is_null($noOfChildren) && !(is_int($noOfChildren) || ctype_digit($noOfChildren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($noOfChildren, true), gettype($noOfChildren)), __LINE__);
        }
        $this->NoOfChildren = $noOfChildren;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\DTVTUnit
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DTVTUnit
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\DTVTUnit
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\DTVTUnit
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\DTVTUnit
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get WebAddress value
     * @return string|null
     */
    public function getWebAddress()
    {
        return $this->WebAddress;
    }
    /**
     * Set WebAddress value
     * @param string $webAddress
     * @return \StructType\DTVTUnit
     */
    public function setWebAddress($webAddress = null)
    {
        // validation for constraint: string
        if (!is_null($webAddress) && !is_string($webAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddress, true), gettype($webAddress)), __LINE__);
        }
        $this->WebAddress = $webAddress;
        return $this;
    }
}
