<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DTVTClasses StructType
 * @subpackage Structs
 */
class DTVTClasses extends AbstractStructBase
{
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjectID;
    /**
     * The Control
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Control;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The WebAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebAddress;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The TCNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TCNumber;
    /**
     * The Town
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Appeal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Appeal;
    /**
     * The Kep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kep;
    /**
     * Constructor method for DTVTClasses
     * @uses DTVTClasses::setObjectID()
     * @uses DTVTClasses::setControl()
     * @uses DTVTClasses::setCode()
     * @uses DTVTClasses::setName()
     * @uses DTVTClasses::setAddress()
     * @uses DTVTClasses::setPhoneNumber()
     * @uses DTVTClasses::setEmail()
     * @uses DTVTClasses::setWebAddress()
     * @uses DTVTClasses::setFax()
     * @uses DTVTClasses::setDescription()
     * @uses DTVTClasses::setTCNumber()
     * @uses DTVTClasses::setTown()
     * @uses DTVTClasses::setAppeal()
     * @uses DTVTClasses::setKep()
     * @param int $objectID
     * @param int $control
     * @param string $code
     * @param string $name
     * @param string $address
     * @param string $phoneNumber
     * @param string $email
     * @param string $webAddress
     * @param string $fax
     * @param string $description
     * @param string $tCNumber
     * @param string $town
     * @param string $appeal
     * @param string $kep
     */
    public function __construct($objectID = null, $control = null, $code = null, $name = null, $address = null, $phoneNumber = null, $email = null, $webAddress = null, $fax = null, $description = null, $tCNumber = null, $town = null, $appeal = null, $kep = null)
    {
        $this
            ->setObjectID($objectID)
            ->setControl($control)
            ->setCode($code)
            ->setName($name)
            ->setAddress($address)
            ->setPhoneNumber($phoneNumber)
            ->setEmail($email)
            ->setWebAddress($webAddress)
            ->setFax($fax)
            ->setDescription($description)
            ->setTCNumber($tCNumber)
            ->setTown($town)
            ->setAppeal($appeal)
            ->setKep($kep);
    }
    /**
     * Get ObjectID value
     * @return int
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param int $objectID
     * @return \StructType\DTVTClasses
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get Control value
     * @return int
     */
    public function getControl()
    {
        return $this->Control;
    }
    /**
     * Set Control value
     * @param int $control
     * @return \StructType\DTVTClasses
     */
    public function setControl($control = null)
    {
        // validation for constraint: int
        if (!is_null($control) && !(is_int($control) || ctype_digit($control))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($control, true), gettype($control)), __LINE__);
        }
        $this->Control = $control;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\DTVTClasses
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\DTVTClasses
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\DTVTClasses
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\DTVTClasses
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\DTVTClasses
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get WebAddress value
     * @return string|null
     */
    public function getWebAddress()
    {
        return $this->WebAddress;
    }
    /**
     * Set WebAddress value
     * @param string $webAddress
     * @return \StructType\DTVTClasses
     */
    public function setWebAddress($webAddress = null)
    {
        // validation for constraint: string
        if (!is_null($webAddress) && !is_string($webAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddress, true), gettype($webAddress)), __LINE__);
        }
        $this->WebAddress = $webAddress;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\DTVTClasses
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\DTVTClasses
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TCNumber value
     * @return string|null
     */
    public function getTCNumber()
    {
        return $this->TCNumber;
    }
    /**
     * Set TCNumber value
     * @param string $tCNumber
     * @return \StructType\DTVTClasses
     */
    public function setTCNumber($tCNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tCNumber) && !is_string($tCNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCNumber, true), gettype($tCNumber)), __LINE__);
        }
        $this->TCNumber = $tCNumber;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \StructType\DTVTClasses
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Appeal value
     * @return string|null
     */
    public function getAppeal()
    {
        return $this->Appeal;
    }
    /**
     * Set Appeal value
     * @param string $appeal
     * @return \StructType\DTVTClasses
     */
    public function setAppeal($appeal = null)
    {
        // validation for constraint: string
        if (!is_null($appeal) && !is_string($appeal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appeal, true), gettype($appeal)), __LINE__);
        }
        $this->Appeal = $appeal;
        return $this;
    }
    /**
     * Get Kep value
     * @return string|null
     */
    public function getKep()
    {
        return $this->Kep;
    }
    /**
     * Set Kep value
     * @param string $kep
     * @return \StructType\DTVTClasses
     */
    public function setKep($kep = null)
    {
        // validation for constraint: string
        if (!is_null($kep) && !is_string($kep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kep, true), gettype($kep)), __LINE__);
        }
        $this->Kep = $kep;
        return $this;
    }
}
