<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Appendix StructType
 * @subpackage Structs
 */
class Appendix extends AbstractStructBase
{
    /**
     * The ObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjectID;
    /**
     * The DocumentObjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DocumentObjectID;
    /**
     * The BlobDataID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BlobDataID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The VekilID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VekilID;
    /**
     * The IsPublishedVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsPublishedVersion;
    /**
     * The BlobSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BlobSize;
    /**
     * The IsLocked
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLocked;
    /**
     * The IsBlobFromDirectory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBlobFromDirectory;
    /**
     * The NonAppendix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NonAppendix;
    /**
     * The ShowDateNumberAppendix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowDateNumberAppendix;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The VersionNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VersionNo;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Extension;
    /**
     * The CreatedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDate;
    /**
     * The CreatedTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedTime;
    /**
     * The PublishedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PublishedDate;
    /**
     * The FilePath
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FilePath;
    /**
     * The PublishStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PublishStatus;
    /**
     * The CodingSchema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodingSchema;
    /**
     * The Resolution
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resolution;
    /**
     * The Compression
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Compression;
    /**
     * The ArchiveFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArchiveFormat;
    /**
     * Constructor method for Appendix
     * @uses Appendix::setObjectID()
     * @uses Appendix::setDocumentObjectID()
     * @uses Appendix::setBlobDataID()
     * @uses Appendix::setUserID()
     * @uses Appendix::setVekilID()
     * @uses Appendix::setIsPublishedVersion()
     * @uses Appendix::setBlobSize()
     * @uses Appendix::setIsLocked()
     * @uses Appendix::setIsBlobFromDirectory()
     * @uses Appendix::setNonAppendix()
     * @uses Appendix::setShowDateNumberAppendix()
     * @uses Appendix::setName()
     * @uses Appendix::setVersionNo()
     * @uses Appendix::setExtension()
     * @uses Appendix::setCreatedDate()
     * @uses Appendix::setCreatedTime()
     * @uses Appendix::setPublishedDate()
     * @uses Appendix::setFilePath()
     * @uses Appendix::setPublishStatus()
     * @uses Appendix::setCodingSchema()
     * @uses Appendix::setResolution()
     * @uses Appendix::setCompression()
     * @uses Appendix::setArchiveFormat()
     * @param int $objectID
     * @param int $documentObjectID
     * @param int $blobDataID
     * @param int $userID
     * @param int $vekilID
     * @param int $isPublishedVersion
     * @param int $blobSize
     * @param bool $isLocked
     * @param bool $isBlobFromDirectory
     * @param bool $nonAppendix
     * @param bool $showDateNumberAppendix
     * @param string $name
     * @param string $versionNo
     * @param string $extension
     * @param string $createdDate
     * @param string $createdTime
     * @param string $publishedDate
     * @param string $filePath
     * @param string $publishStatus
     * @param string $codingSchema
     * @param string $resolution
     * @param string $compression
     * @param string $archiveFormat
     */
    public function __construct($objectID = null, $documentObjectID = null, $blobDataID = null, $userID = null, $vekilID = null, $isPublishedVersion = null, $blobSize = null, $isLocked = null, $isBlobFromDirectory = null, $nonAppendix = null, $showDateNumberAppendix = null, $name = null, $versionNo = null, $extension = null, $createdDate = null, $createdTime = null, $publishedDate = null, $filePath = null, $publishStatus = null, $codingSchema = null, $resolution = null, $compression = null, $archiveFormat = null)
    {
        $this
            ->setObjectID($objectID)
            ->setDocumentObjectID($documentObjectID)
            ->setBlobDataID($blobDataID)
            ->setUserID($userID)
            ->setVekilID($vekilID)
            ->setIsPublishedVersion($isPublishedVersion)
            ->setBlobSize($blobSize)
            ->setIsLocked($isLocked)
            ->setIsBlobFromDirectory($isBlobFromDirectory)
            ->setNonAppendix($nonAppendix)
            ->setShowDateNumberAppendix($showDateNumberAppendix)
            ->setName($name)
            ->setVersionNo($versionNo)
            ->setExtension($extension)
            ->setCreatedDate($createdDate)
            ->setCreatedTime($createdTime)
            ->setPublishedDate($publishedDate)
            ->setFilePath($filePath)
            ->setPublishStatus($publishStatus)
            ->setCodingSchema($codingSchema)
            ->setResolution($resolution)
            ->setCompression($compression)
            ->setArchiveFormat($archiveFormat);
    }
    /**
     * Get ObjectID value
     * @return int
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param int $objectID
     * @return \StructType\Appendix
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: int
        if (!is_null($objectID) && !(is_int($objectID) || ctype_digit($objectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objectID, true), gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get DocumentObjectID value
     * @return int
     */
    public function getDocumentObjectID()
    {
        return $this->DocumentObjectID;
    }
    /**
     * Set DocumentObjectID value
     * @param int $documentObjectID
     * @return \StructType\Appendix
     */
    public function setDocumentObjectID($documentObjectID = null)
    {
        // validation for constraint: int
        if (!is_null($documentObjectID) && !(is_int($documentObjectID) || ctype_digit($documentObjectID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentObjectID, true), gettype($documentObjectID)), __LINE__);
        }
        $this->DocumentObjectID = $documentObjectID;
        return $this;
    }
    /**
     * Get BlobDataID value
     * @return int
     */
    public function getBlobDataID()
    {
        return $this->BlobDataID;
    }
    /**
     * Set BlobDataID value
     * @param int $blobDataID
     * @return \StructType\Appendix
     */
    public function setBlobDataID($blobDataID = null)
    {
        // validation for constraint: int
        if (!is_null($blobDataID) && !(is_int($blobDataID) || ctype_digit($blobDataID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blobDataID, true), gettype($blobDataID)), __LINE__);
        }
        $this->BlobDataID = $blobDataID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\Appendix
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get VekilID value
     * @return int
     */
    public function getVekilID()
    {
        return $this->VekilID;
    }
    /**
     * Set VekilID value
     * @param int $vekilID
     * @return \StructType\Appendix
     */
    public function setVekilID($vekilID = null)
    {
        // validation for constraint: int
        if (!is_null($vekilID) && !(is_int($vekilID) || ctype_digit($vekilID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vekilID, true), gettype($vekilID)), __LINE__);
        }
        $this->VekilID = $vekilID;
        return $this;
    }
    /**
     * Get IsPublishedVersion value
     * @return int
     */
    public function getIsPublishedVersion()
    {
        return $this->IsPublishedVersion;
    }
    /**
     * Set IsPublishedVersion value
     * @param int $isPublishedVersion
     * @return \StructType\Appendix
     */
    public function setIsPublishedVersion($isPublishedVersion = null)
    {
        // validation for constraint: int
        if (!is_null($isPublishedVersion) && !(is_int($isPublishedVersion) || ctype_digit($isPublishedVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isPublishedVersion, true), gettype($isPublishedVersion)), __LINE__);
        }
        $this->IsPublishedVersion = $isPublishedVersion;
        return $this;
    }
    /**
     * Get BlobSize value
     * @return int
     */
    public function getBlobSize()
    {
        return $this->BlobSize;
    }
    /**
     * Set BlobSize value
     * @param int $blobSize
     * @return \StructType\Appendix
     */
    public function setBlobSize($blobSize = null)
    {
        // validation for constraint: int
        if (!is_null($blobSize) && !(is_int($blobSize) || ctype_digit($blobSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blobSize, true), gettype($blobSize)), __LINE__);
        }
        $this->BlobSize = $blobSize;
        return $this;
    }
    /**
     * Get IsLocked value
     * @return bool
     */
    public function getIsLocked()
    {
        return $this->IsLocked;
    }
    /**
     * Set IsLocked value
     * @param bool $isLocked
     * @return \StructType\Appendix
     */
    public function setIsLocked($isLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLocked) && !is_bool($isLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLocked, true), gettype($isLocked)), __LINE__);
        }
        $this->IsLocked = $isLocked;
        return $this;
    }
    /**
     * Get IsBlobFromDirectory value
     * @return bool
     */
    public function getIsBlobFromDirectory()
    {
        return $this->IsBlobFromDirectory;
    }
    /**
     * Set IsBlobFromDirectory value
     * @param bool $isBlobFromDirectory
     * @return \StructType\Appendix
     */
    public function setIsBlobFromDirectory($isBlobFromDirectory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBlobFromDirectory) && !is_bool($isBlobFromDirectory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBlobFromDirectory, true), gettype($isBlobFromDirectory)), __LINE__);
        }
        $this->IsBlobFromDirectory = $isBlobFromDirectory;
        return $this;
    }
    /**
     * Get NonAppendix value
     * @return bool
     */
    public function getNonAppendix()
    {
        return $this->NonAppendix;
    }
    /**
     * Set NonAppendix value
     * @param bool $nonAppendix
     * @return \StructType\Appendix
     */
    public function setNonAppendix($nonAppendix = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonAppendix) && !is_bool($nonAppendix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonAppendix, true), gettype($nonAppendix)), __LINE__);
        }
        $this->NonAppendix = $nonAppendix;
        return $this;
    }
    /**
     * Get ShowDateNumberAppendix value
     * @return bool
     */
    public function getShowDateNumberAppendix()
    {
        return $this->ShowDateNumberAppendix;
    }
    /**
     * Set ShowDateNumberAppendix value
     * @param bool $showDateNumberAppendix
     * @return \StructType\Appendix
     */
    public function setShowDateNumberAppendix($showDateNumberAppendix = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDateNumberAppendix) && !is_bool($showDateNumberAppendix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDateNumberAppendix, true), gettype($showDateNumberAppendix)), __LINE__);
        }
        $this->ShowDateNumberAppendix = $showDateNumberAppendix;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Appendix
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get VersionNo value
     * @return string|null
     */
    public function getVersionNo()
    {
        return $this->VersionNo;
    }
    /**
     * Set VersionNo value
     * @param string $versionNo
     * @return \StructType\Appendix
     */
    public function setVersionNo($versionNo = null)
    {
        // validation for constraint: string
        if (!is_null($versionNo) && !is_string($versionNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionNo, true), gettype($versionNo)), __LINE__);
        }
        $this->VersionNo = $versionNo;
        return $this;
    }
    /**
     * Get Extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @param string $extension
     * @return \StructType\Appendix
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\Appendix
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get CreatedTime value
     * @return string|null
     */
    public function getCreatedTime()
    {
        return $this->CreatedTime;
    }
    /**
     * Set CreatedTime value
     * @param string $createdTime
     * @return \StructType\Appendix
     */
    public function setCreatedTime($createdTime = null)
    {
        // validation for constraint: string
        if (!is_null($createdTime) && !is_string($createdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdTime, true), gettype($createdTime)), __LINE__);
        }
        $this->CreatedTime = $createdTime;
        return $this;
    }
    /**
     * Get PublishedDate value
     * @return string|null
     */
    public function getPublishedDate()
    {
        return $this->PublishedDate;
    }
    /**
     * Set PublishedDate value
     * @param string $publishedDate
     * @return \StructType\Appendix
     */
    public function setPublishedDate($publishedDate = null)
    {
        // validation for constraint: string
        if (!is_null($publishedDate) && !is_string($publishedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishedDate, true), gettype($publishedDate)), __LINE__);
        }
        $this->PublishedDate = $publishedDate;
        return $this;
    }
    /**
     * Get FilePath value
     * @return string|null
     */
    public function getFilePath()
    {
        return $this->FilePath;
    }
    /**
     * Set FilePath value
     * @param string $filePath
     * @return \StructType\Appendix
     */
    public function setFilePath($filePath = null)
    {
        // validation for constraint: string
        if (!is_null($filePath) && !is_string($filePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filePath, true), gettype($filePath)), __LINE__);
        }
        $this->FilePath = $filePath;
        return $this;
    }
    /**
     * Get PublishStatus value
     * @return string|null
     */
    public function getPublishStatus()
    {
        return $this->PublishStatus;
    }
    /**
     * Set PublishStatus value
     * @param string $publishStatus
     * @return \StructType\Appendix
     */
    public function setPublishStatus($publishStatus = null)
    {
        // validation for constraint: string
        if (!is_null($publishStatus) && !is_string($publishStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publishStatus, true), gettype($publishStatus)), __LINE__);
        }
        $this->PublishStatus = $publishStatus;
        return $this;
    }
    /**
     * Get CodingSchema value
     * @return string|null
     */
    public function getCodingSchema()
    {
        return $this->CodingSchema;
    }
    /**
     * Set CodingSchema value
     * @param string $codingSchema
     * @return \StructType\Appendix
     */
    public function setCodingSchema($codingSchema = null)
    {
        // validation for constraint: string
        if (!is_null($codingSchema) && !is_string($codingSchema)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codingSchema, true), gettype($codingSchema)), __LINE__);
        }
        $this->CodingSchema = $codingSchema;
        return $this;
    }
    /**
     * Get Resolution value
     * @return string|null
     */
    public function getResolution()
    {
        return $this->Resolution;
    }
    /**
     * Set Resolution value
     * @param string $resolution
     * @return \StructType\Appendix
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: string
        if (!is_null($resolution) && !is_string($resolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->Resolution = $resolution;
        return $this;
    }
    /**
     * Get Compression value
     * @return string|null
     */
    public function getCompression()
    {
        return $this->Compression;
    }
    /**
     * Set Compression value
     * @param string $compression
     * @return \StructType\Appendix
     */
    public function setCompression($compression = null)
    {
        // validation for constraint: string
        if (!is_null($compression) && !is_string($compression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compression, true), gettype($compression)), __LINE__);
        }
        $this->Compression = $compression;
        return $this;
    }
    /**
     * Get ArchiveFormat value
     * @return string|null
     */
    public function getArchiveFormat()
    {
        return $this->ArchiveFormat;
    }
    /**
     * Set ArchiveFormat value
     * @param string $archiveFormat
     * @return \StructType\Appendix
     */
    public function setArchiveFormat($archiveFormat = null)
    {
        // validation for constraint: string
        if (!is_null($archiveFormat) && !is_string($archiveFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveFormat, true), gettype($archiveFormat)), __LINE__);
        }
        $this->ArchiveFormat = $archiveFormat;
        return $this;
    }
}
