<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Sets the AuthCredential SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AuthCredential $authCredential
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthCredential(\StructType\AuthCredential $authCredential, $nameSpace = 'http://ebys.bivent.com.tr/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'AuthCredential', $authCredential, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SaveDynamicWorkFlow
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveDynamicWorkFlow $parameters
     * @return \StructType\SaveDynamicWorkFlowResponse|bool
     */
    public function SaveDynamicWorkFlow(\StructType\SaveDynamicWorkFlow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveDynamicWorkFlow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named saveDocumentTypeProfileValues
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveDocumentTypeProfileValues $parameters
     * @return \StructType\SaveDocumentTypeProfileValuesResponse|bool
     */
    public function saveDocumentTypeProfileValues(\StructType\SaveDocumentTypeProfileValues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->saveDocumentTypeProfileValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * saveDocumentTypeProfileValuesPrinter
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveDocumentTypeProfileValuesPrinter $parameters
     * @return \StructType\SaveDocumentTypeProfileValuesPrinterResponse|bool
     */
    public function saveDocumentTypeProfileValuesPrinter(\StructType\SaveDocumentTypeProfileValuesPrinter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->saveDocumentTypeProfileValuesPrinter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveDynamicWorkFlowGS
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveDynamicWorkFlowGS $parameters
     * @return \StructType\SaveDynamicWorkFlowGSResponse|bool
     */
    public function SaveDynamicWorkFlowGS(\StructType\SaveDynamicWorkFlowGS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveDynamicWorkFlowGS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveObjectGS
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: AuthCredential
     * - SOAPHeaderNamespaces: http://ebys.bivent.com.tr/
     * - SOAPHeaderTypes: \StructType\AuthCredential
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveObjectGS $parameters
     * @return \StructType\SaveObjectGSResponse|bool
     */
    public function SaveObjectGS(\StructType\SaveObjectGS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveObjectGS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveDocumentTypeProfileValuesPrinterResponse|\StructType\SaveDocumentTypeProfileValuesResponse|\StructType\SaveDynamicWorkFlowGSResponse|\StructType\SaveDynamicWorkFlowResponse|\StructType\SaveObjectGSResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
