<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDTVTUnit ArrayType
 * @subpackage Arrays
 */
class ArrayOfDTVTUnit extends AbstractStructArrayBase
{
    /**
     * The DTVTUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DTVTUnit[]
     */
    public $DTVTUnit;
    /**
     * Constructor method for ArrayOfDTVTUnit
     * @uses ArrayOfDTVTUnit::setDTVTUnit()
     * @param \StructType\DTVTUnit[] $dTVTUnit
     */
    public function __construct(array $dTVTUnit = array())
    {
        $this
            ->setDTVTUnit($dTVTUnit);
    }
    /**
     * Get DTVTUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DTVTUnit[]|null
     */
    public function getDTVTUnit()
    {
        return isset($this->DTVTUnit) ? $this->DTVTUnit : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDTVTUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDTVTUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDTVTUnitForArrayConstraintsFromSetDTVTUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDTVTUnitDTVTUnitItem) {
            // validation for constraint: itemType
            if (!$arrayOfDTVTUnitDTVTUnitItem instanceof \StructType\DTVTUnit) {
                $invalidValues[] = is_object($arrayOfDTVTUnitDTVTUnitItem) ? get_class($arrayOfDTVTUnitDTVTUnitItem) : sprintf('%s(%s)', gettype($arrayOfDTVTUnitDTVTUnitItem), var_export($arrayOfDTVTUnitDTVTUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DTVTUnit property can only contain items of type \StructType\DTVTUnit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DTVTUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DTVTUnit[] $dTVTUnit
     * @return \ArrayType\ArrayOfDTVTUnit
     */
    public function setDTVTUnit(array $dTVTUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($dTVTUnitArrayErrorMessage = self::validateDTVTUnitForArrayConstraintsFromSetDTVTUnit($dTVTUnit))) {
            throw new \InvalidArgumentException($dTVTUnitArrayErrorMessage, __LINE__);
        }
        if (is_null($dTVTUnit) || (is_array($dTVTUnit) && empty($dTVTUnit))) {
            unset($this->DTVTUnit);
        } else {
            $this->DTVTUnit = $dTVTUnit;
        }
        return $this;
    }
    /**
     * Add item to DTVTUnit value
     * @throws \InvalidArgumentException
     * @param \StructType\DTVTUnit $item
     * @return \ArrayType\ArrayOfDTVTUnit
     */
    public function addToDTVTUnit(\StructType\DTVTUnit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DTVTUnit) {
            throw new \InvalidArgumentException(sprintf('The DTVTUnit property can only contain items of type \StructType\DTVTUnit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DTVTUnit[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DTVTUnit|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DTVTUnit|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DTVTUnit|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DTVTUnit|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DTVTUnit|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DTVTUnit
     */
    public function getAttributeName()
    {
        return 'DTVTUnit';
    }
}
