<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
/**
 * Sample call for CancelarNfse operation/method
 */
if ($cancelar->CancelarNfse(new \StructType\Input()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for ConsultarLoteRps operation/method
 */
if ($consultar->ConsultarLoteRps(new \StructType\Input()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarNfseServicoPrestado operation/method
 */
if ($consultar->ConsultarNfseServicoPrestado(new \StructType\Input()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarNfseServicoTomado operation/method
 */
if ($consultar->ConsultarNfseServicoTomado(new \StructType\Input()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarNfsePorFaixa operation/method
 */
if ($consultar->ConsultarNfsePorFaixa(new \StructType\Input()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarNfsePorRps operation/method
 */
if ($consultar->ConsultarNfsePorRps(new \StructType\Input()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Samples for Recepcionar ServiceType
 */
$recepcionar = new \ServiceType\Recepcionar($options);
/**
 * Sample call for RecepcionarLoteRps operation/method
 */
if ($recepcionar->RecepcionarLoteRps(new \StructType\Input()) !== false) {
    print_r($recepcionar->getResult());
} else {
    print_r($recepcionar->getLastError());
}
/**
 * Sample call for RecepcionarLoteRpsSincrono operation/method
 */
if ($recepcionar->RecepcionarLoteRpsSincrono(new \StructType\Input()) !== false) {
    print_r($recepcionar->getResult());
} else {
    print_r($recepcionar->getLastError());
}
/**
 * Samples for Gerar ServiceType
 */
$gerar = new \ServiceType\Gerar($options);
/**
 * Sample call for GerarNfse operation/method
 */
if ($gerar->GerarNfse(new \StructType\Input()) !== false) {
    print_r($gerar->getResult());
} else {
    print_r($gerar->getLastError());
}
/**
 * Samples for Substituir ServiceType
 */
$substituir = new \ServiceType\Substituir($options);
/**
 * Sample call for SubstituirNfse operation/method
 */
if ($substituir->SubstituirNfse(new \StructType\Input()) !== false) {
    print_r($substituir->getResult());
} else {
    print_r($substituir->getLastError());
}
