<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultarLoteRps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function ConsultarLoteRps(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarLoteRps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarNfseServicoPrestado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function ConsultarNfseServicoPrestado(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarNfseServicoPrestado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarNfseServicoTomado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function ConsultarNfseServicoTomado(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarNfseServicoTomado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarNfsePorFaixa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function ConsultarNfsePorFaixa(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarNfsePorFaixa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarNfsePorRps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function ConsultarNfsePorRps(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarNfsePorRps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Output
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
