<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for output StructType
 * @subpackage Structs
 */
class Output extends AbstractStructBase
{
    /**
     * The outputXML
     * @var string
     */
    public $outputXML;
    /**
     * Constructor method for output
     * @uses Output::setOutputXML()
     * @param string $outputXML
     */
    public function __construct($outputXML = null)
    {
        $this
            ->setOutputXML($outputXML);
    }
    /**
     * Get outputXML value
     * @return string|null
     */
    public function getOutputXML()
    {
        return $this->outputXML;
    }
    /**
     * Set outputXML value
     * @param string $outputXML
     * @return \StructType\Output
     */
    public function setOutputXML($outputXML = null)
    {
        // validation for constraint: string
        if (!is_null($outputXML) && !is_string($outputXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outputXML, true), gettype($outputXML)), __LINE__);
        }
        $this->outputXML = $outputXML;
        return $this;
    }
}
