<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recepcionar ServiceType
 * @subpackage Services
 */
class Recepcionar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecepcionarLoteRps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function RecepcionarLoteRps(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecepcionarLoteRps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecepcionarLoteRpsSincrono
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Input $parameters
     * @return \StructType\Output|bool
     */
    public function RecepcionarLoteRpsSincrono(\StructType\Input $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecepcionarLoteRpsSincrono($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Output
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
