<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tie ServiceType
 * @subpackage Services
 */
class Tie extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named tieUp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param tieUp $tieUp
     * @return tieUpResponse|bool
     */
    public function tieUp($tieUp)
    {
        try {
            $this->setResult($this->getSoapClient()->tieUp($tieUp));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return tieUpResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
