<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sey ServiceType
 * @subpackage Services
 */
class Sey extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named seyHello
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param seyHello $seyHello
     * @return seyHelloResponse|bool
     */
    public function seyHello($seyHello)
    {
        try {
            $this->setResult($this->getSoapClient()->seyHello($seyHello));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return seyHelloResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
