<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prem ServiceType
 * @subpackage Services
 */
class Prem extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PremFromFirstPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param PremFromFirstPolicy $premFromFirstPolicy
     * @return PremFromFirstPolicyResponse|bool
     */
    public function PremFromFirstPolicy($premFromFirstPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->PremFromFirstPolicy($premFromFirstPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return PremFromFirstPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
