<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Merge ServiceType
 * @subpackage Services
 */
class Merge extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mergeSiebelBoxClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param mergeSiebelBoxClient $mergeSiebelBoxClient
     * @return mergeSiebelBoxClientResponse|bool
     */
    public function mergeSiebelBoxClient($mergeSiebelBoxClient)
    {
        try {
            $this->setResult($this->getSoapClient()->mergeSiebelBoxClient($mergeSiebelBoxClient));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return mergeSiebelBoxClientResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
