<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCurrencyRate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCurrencyRate $getCurrencyRate
     * @return getCurrencyRateResponse|bool
     */
    public function getCurrencyRate($getCurrencyRate)
    {
        try {
            $this->setResult($this->getSoapClient()->getCurrencyRate($getCurrencyRate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getDictionary $getDictionary
     * @return getDictionaryResponse|bool
     */
    public function getDictionary($getDictionary)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionary($getDictionary));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLimitConditions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getLimitConditions $getLimitConditions
     * @return getLimitConditionsResponse|bool
     */
    public function getLimitConditions($getLimitConditions)
    {
        try {
            $this->setResult($this->getSoapClient()->getLimitConditions($getLimitConditions));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPeopleShort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPeopleShort $getPeopleShort
     * @return getPeopleShortResponse|bool
     */
    public function getPeopleShort($getPeopleShort)
    {
        try {
            $this->setResult($this->getSoapClient()->getPeopleShort($getPeopleShort));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarShort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCarShort $getCarShort
     * @return getCarShortResponse|bool
     */
    public function getCarShort($getCarShort)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarShort($getCarShort));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOnlinePolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getOnlinePolicies $getOnlinePolicies
     * @return getOnlinePoliciesResponse|bool
     */
    public function getOnlinePolicies($getOnlinePolicies)
    {
        try {
            $this->setResult($this->getSoapClient()->getOnlinePolicies($getOnlinePolicies));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVierifiedPeopleByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getVierifiedPeopleByKeyFields $getVierifiedPeopleByKeyFields
     * @return getVierifiedPeopleByKeyFieldsResponse|bool
     */
    public function getVierifiedPeopleByKeyFields($getVierifiedPeopleByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getVierifiedPeopleByKeyFields($getVierifiedPeopleByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerifiedPeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getVerifiedPeople $getVerifiedPeople
     * @return getVerifiedPeopleResponse|bool
     */
    public function getVerifiedPeople($getVerifiedPeople)
    {
        try {
            $this->setResult($this->getSoapClient()->getVerifiedPeople($getVerifiedPeople));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGuidBank
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getGuidBank $getGuidBank
     * @return getGuidBankResponse|bool
     */
    public function getGuidBank($getGuidBank)
    {
        try {
            $this->setResult($this->getSoapClient()->getGuidBank($getGuidBank));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOnlineCover
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getOnlineCover $getOnlineCover
     * @return getOnlineCoverResponse|bool
     */
    public function getOnlineCover($getOnlineCover)
    {
        try {
            $this->setResult($this->getSoapClient()->getOnlineCover($getOnlineCover));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOGPOFlagsByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getOGPOFlagsByIIN $getOGPOFlagsByIIN
     * @return getOGPOFlagsByIINResponse|bool
     */
    public function getOGPOFlagsByIIN($getOGPOFlagsByIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->getOGPOFlagsByIIN($getOGPOFlagsByIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHalykTravelByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getHalykTravelByKeyFields $getHalykTravelByKeyFields
     * @return getHalykTravelByKeyFieldsResponse|bool
     */
    public function getHalykTravelByKeyFields($getHalykTravelByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getHalykTravelByKeyFields($getHalykTravelByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNameByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getNameByIIN $getNameByIIN
     * @return getNameByIINResponse|bool
     */
    public function getNameByIIN($getNameByIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->getNameByIIN($getNameByIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMarkTS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getMarkTS $getMarkTS
     * @return getMarkTSResponse|bool
     */
    public function getMarkTS($getMarkTS)
    {
        try {
            $this->setResult($this->getSoapClient()->getMarkTS($getMarkTS));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCarByNumber $getCarByNumber
     * @return getCarByNumberResponse|bool
     */
    public function getCarByNumber($getCarByNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarByNumber($getCarByNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyIDbyRef
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPolicyIDbyRef $getPolicyIDbyRef
     * @return getPolicyIDbyRefResponse|bool
     */
    public function getPolicyIDbyRef($getPolicyIDbyRef)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyIDbyRef($getPolicyIDbyRef));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumOGPOAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPremiumOGPOAuto $getPremiumOGPOAuto
     * @return getPremiumOGPOAutoResponse|bool
     */
    public function getPremiumOGPOAuto($getPremiumOGPOAuto)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumOGPOAuto($getPremiumOGPOAuto));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumOGPOAutoByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPremiumOGPOAutoByIIN $getPremiumOGPOAutoByIIN
     * @return getPremiumOGPOAutoByIINResponse|bool
     */
    public function getPremiumOGPOAutoByIIN($getPremiumOGPOAutoByIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumOGPOAutoByIIN($getPremiumOGPOAutoByIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClientClass $getClientClass
     * @return getClientClassResponse|bool
     */
    public function getClientClass($getClientClass)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClass($getClientClass));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCarInfo $getCarInfo
     * @return getCarInfoResponse|bool
     */
    public function getCarInfo($getCarInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarInfo($getCarInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumTravelPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPremiumTravelPolicy $getPremiumTravelPolicy
     * @return getPremiumTravelPolicyResponse|bool
     */
    public function getPremiumTravelPolicy($getPremiumTravelPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumTravelPolicy($getPremiumTravelPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxes $getBoxes
     * @return getBoxesResponse|bool
     */
    public function getBoxes($getBoxes)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxes($getBoxes));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxPremium
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxPremium $getBoxPremium
     * @return getBoxPremiumResponse|bool
     */
    public function getBoxPremium($getBoxPremium)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxPremium($getBoxPremium));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxPremiumByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxPremiumByIIN $getBoxPremiumByIIN
     * @return getBoxPremiumByIINResponse|bool
     */
    public function getBoxPremiumByIIN($getBoxPremiumByIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxPremiumByIIN($getBoxPremiumByIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxPayment $getBoxPayment
     * @return getBoxPaymentResponse|bool
     */
    public function getBoxPayment($getBoxPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxPayment($getBoxPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxIdByNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxIdByNumber $getBoxIdByNumber
     * @return getBoxIdByNumberResponse|bool
     */
    public function getBoxIdByNumber($getBoxIdByNumber)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxIdByNumber($getBoxIdByNumber));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxStatus $getBoxStatus
     * @return getBoxStatusResponse|bool
     */
    public function getBoxStatus($getBoxStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxStatus($getBoxStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoxByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBoxByKeyFields $getBoxByKeyFields
     * @return getBoxByKeyFieldsResponse|bool
     */
    public function getBoxByKeyFields($getBoxByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getBoxByKeyFields($getBoxByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSiebelBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getSiebelBoxPayment $getSiebelBoxPayment
     * @return getSiebelBoxPaymentResponse|bool
     */
    public function getSiebelBoxPayment($getSiebelBoxPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->getSiebelBoxPayment($getSiebelBoxPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSiebelBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getSiebelBox $getSiebelBox
     * @return getSiebelBoxResponse|bool
     */
    public function getSiebelBox($getSiebelBox)
    {
        try {
            $this->setResult($this->getSoapClient()->getSiebelBox($getSiebelBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStaffByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getStaffByKeyFields $getStaffByKeyFields
     * @return getStaffByKeyFieldsResponse|bool
     */
    public function getStaffByKeyFields($getStaffByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getStaffByKeyFields($getStaffByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getReport $getReport
     * @return getReportResponse|bool
     */
    public function getReport($getReport)
    {
        try {
            $this->setResult($this->getSoapClient()->getReport($getReport));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportParams
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getReportParams $getReportParams
     * @return getReportParamsResponse|bool
     */
    public function getReportParams($getReportParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getReportParams($getReportParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAvailableReports
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getAvailableReports $getAvailableReports
     * @return getAvailableReportsResponse|bool
     */
    public function getAvailableReports($getAvailableReports)
    {
        try {
            $this->setResult($this->getSoapClient()->getAvailableReports($getAvailableReports));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectCarByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getObjectCarByKeyFields $getObjectCarByKeyFields
     * @return getObjectCarByKeyFieldsResponse|bool
     */
    public function getObjectCarByKeyFields($getObjectCarByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getObjectCarByKeyFields($getObjectCarByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCarViolations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCarViolations $getCarViolations
     * @return getCarViolationsResponse|bool
     */
    public function getCarViolations($getCarViolations)
    {
        try {
            $this->setResult($this->getSoapClient()->getCarViolations($getCarViolations));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartRiskValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getStandartRiskValues $getStandartRiskValues
     * @return getStandartRiskValuesResponse|bool
     */
    public function getStandartRiskValues($getStandartRiskValues)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartRiskValues($getStandartRiskValues));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAgentByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getAgentByKeyFields $getAgentByKeyFields
     * @return getAgentByKeyFieldsResponse|bool
     */
    public function getAgentByKeyFields($getAgentByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getAgentByKeyFields($getAgentByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartCovers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getStandartCovers $getStandartCovers
     * @return getStandartCoversResponse|bool
     */
    public function getStandartCovers($getStandartCovers)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartCovers($getStandartCovers));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTariffList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getTariffList $getTariffList
     * @return getTariffListResponse|bool
     */
    public function getTariffList($getTariffList)
    {
        try {
            $this->setResult($this->getSoapClient()->getTariffList($getTariffList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlanksNumbers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBlanksNumbers $getBlanksNumbers
     * @return getBlanksNumbersResponse|bool
     */
    public function getBlanksNumbers($getBlanksNumbers)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlanksNumbers($getBlanksNumbers));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBlankByKeyFields $getBlankByKeyFields
     * @return getBlankByKeyFieldsResponse|bool
     */
    public function getBlankByKeyFields($getBlankByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankByKeyFields($getBlankByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlanksNumbersByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBlanksNumbersByIIN $getBlanksNumbersByIIN
     * @return getBlanksNumbersByIINResponse|bool
     */
    public function getBlanksNumbersByIIN($getBlanksNumbersByIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlanksNumbersByIIN($getBlanksNumbersByIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBlankOrders $getBlankOrders
     * @return getBlankOrdersResponse|bool
     */
    public function getBlankOrders($getBlankOrders)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankOrders($getBlankOrders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBillByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBillByKeyFields $getBillByKeyFields
     * @return getBillByKeyFieldsResponse|bool
     */
    public function getBillByKeyFields($getBillByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getBillByKeyFields($getBillByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDocumentAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getDocumentAttachment $getDocumentAttachment
     * @return getDocumentAttachmentResponse|bool
     */
    public function getDocumentAttachment($getDocumentAttachment)
    {
        try {
            $this->setResult($this->getSoapClient()->getDocumentAttachment($getDocumentAttachment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoliciesForPaymentByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPoliciesForPaymentByKeyFields $getPoliciesForPaymentByKeyFields
     * @return getPoliciesForPaymentByKeyFieldsResponse|bool
     */
    public function getPoliciesForPaymentByKeyFields($getPoliciesForPaymentByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getPoliciesForPaymentByKeyFields($getPoliciesForPaymentByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremForSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPremForSite $getPremForSite
     * @return getPremForSiteResponse|bool
     */
    public function getPremForSite($getPremForSite)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremForSite($getPremForSite));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getCallList $getCallList
     * @return getCallListResponse|bool
     */
    public function getCallList($getCallList)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallList($getCallList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyPaidPremium
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPolicyPaidPremium $getPolicyPaidPremium
     * @return getPolicyPaidPremiumResponse|bool
     */
    public function getPolicyPaidPremium($getPolicyPaidPremium)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyPaidPremium($getPolicyPaidPremium));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPremiumAndInsName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPremiumAndInsName $getPremiumAndInsName
     * @return getPremiumAndInsNameResponse|bool
     */
    public function getPremiumAndInsName($getPremiumAndInsName)
    {
        try {
            $this->setResult($this->getSoapClient()->getPremiumAndInsName($getPremiumAndInsName));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlankPrefixes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getBlankPrefixes $getBlankPrefixes
     * @return getBlankPrefixesResponse|bool
     */
    public function getBlankPrefixes($getBlankPrefixes)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlankPrefixes($getBlankPrefixes));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyApps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPolicyApps $getPolicyApps
     * @return getPolicyAppsResponse|bool
     */
    public function getPolicyApps($getPolicyApps)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyApps($getPolicyApps));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInsrTypeCoverInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getInsrTypeCoverInfo $getInsrTypeCoverInfo
     * @return getInsrTypeCoverInfoResponse|bool
     */
    public function getInsrTypeCoverInfo($getInsrTypeCoverInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->getInsrTypeCoverInfo($getInsrTypeCoverInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPoliciesByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPoliciesByKeyFields $getPoliciesByKeyFields
     * @return getPoliciesByKeyFieldsResponse|bool
     */
    public function getPoliciesByKeyFields($getPoliciesByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getPoliciesByKeyFields($getPoliciesByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPolicyPrint $getPolicyPrint
     * @return getPolicyPrintResponse|bool
     */
    public function getPolicyPrint($getPolicyPrint)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyPrint($getPolicyPrint));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrintForm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPrintForm $getPrintForm
     * @return getPrintFormResponse|bool
     */
    public function getPrintForm($getPrintForm)
    {
        try {
            $this->setResult($this->getSoapClient()->getPrintForm($getPrintForm));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartCoverValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getStandartCoverValues $getStandartCoverValues
     * @return getStandartCoverValuesResponse|bool
     */
    public function getStandartCoverValues($getStandartCoverValues)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartCoverValues($getStandartCoverValues));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStandartMultiCoverValues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getStandartMultiCoverValues $getStandartMultiCoverValues
     * @return getStandartMultiCoverValuesResponse|bool
     */
    public function getStandartMultiCoverValues($getStandartMultiCoverValues)
    {
        try {
            $this->setResult($this->getSoapClient()->getStandartMultiCoverValues($getStandartMultiCoverValues));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSouvenirs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getSouvenirs $getSouvenirs
     * @return getSouvenirsResponse|bool
     */
    public function getSouvenirs($getSouvenirs)
    {
        try {
            $this->setResult($this->getSoapClient()->getSouvenirs($getSouvenirs));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArchiveByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getArchiveByKeyFields $getArchiveByKeyFields
     * @return getArchiveByKeyFieldsResponse|bool
     */
    public function getArchiveByKeyFields($getArchiveByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getArchiveByKeyFields($getArchiveByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConfirmList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getConfirmList $getConfirmList
     * @return getConfirmListResponse|bool
     */
    public function getConfirmList($getConfirmList)
    {
        try {
            $this->setResult($this->getSoapClient()->getConfirmList($getConfirmList));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArchivePolicyDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getArchivePolicyDetails $getArchivePolicyDetails
     * @return getArchivePolicyDetailsResponse|bool
     */
    public function getArchivePolicyDetails($getArchivePolicyDetails)
    {
        try {
            $this->setResult($this->getSoapClient()->getArchivePolicyDetails($getArchivePolicyDetails));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClaimByPeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClaimByPeriod $getClaimByPeriod
     * @return getClaimByPeriodResponse|bool
     */
    public function getClaimByPeriod($getClaimByPeriod)
    {
        try {
            $this->setResult($this->getSoapClient()->getClaimByPeriod($getClaimByPeriod));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClaimByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClaimByKeyFields $getClaimByKeyFields
     * @return getClaimByKeyFieldsResponse|bool
     */
    public function getClaimByKeyFields($getClaimByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getClaimByKeyFields($getClaimByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClaimSiteView
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClaimSiteView $getClaimSiteView
     * @return getClaimSiteViewResponse|bool
     */
    public function getClaimSiteView($getClaimSiteView)
    {
        try {
            $this->setResult($this->getSoapClient()->getClaimSiteView($getClaimSiteView));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRZNUByMan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getRZNUByMan $getRZNUByMan
     * @return getRZNUByManResponse|bool
     */
    public function getRZNUByMan($getRZNUByMan)
    {
        try {
            $this->setResult($this->getSoapClient()->getRZNUByMan($getRZNUByMan));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getObjectProperty $getObjectProperty
     * @return getObjectPropertyResponse|bool
     */
    public function getObjectProperty($getObjectProperty)
    {
        try {
            $this->setResult($this->getSoapClient()->getObjectProperty($getObjectProperty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getObjectCargoByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getObjectCargoByKeyFields $getObjectCargoByKeyFields
     * @return getObjectCargoByKeyFieldsResponse|bool
     */
    public function getObjectCargoByKeyFields($getObjectCargoByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getObjectCargoByKeyFields($getObjectCargoByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPeopleByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPeopleByKeyFields $getPeopleByKeyFields
     * @return getPeopleByKeyFieldsResponse|bool
     */
    public function getPeopleByKeyFields($getPeopleByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getPeopleByKeyFields($getPeopleByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClassByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClientClassByKeyFields $getClientClassByKeyFields
     * @return getClientClassByKeyFieldsResponse|bool
     */
    public function getClientClassByKeyFields($getClientClassByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClassByKeyFields($getClientClassByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClassByIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClientClassByIIN $getClientClassByIIN
     * @return getClientClassByIINResponse|bool
     */
    public function getClientClassByIIN($getClientClassByIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClassByIIN($getClientClassByIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClientClassByManID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getClientClassByManID $getClientClassByManID
     * @return getClientClassByManIDResponse|bool
     */
    public function getClientClassByManID($getClientClassByManID)
    {
        try {
            $this->setResult($this->getSoapClient()->getClientClassByManID($getClientClassByManID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaymentInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPaymentInfo $getPaymentInfo
     * @return getPaymentInfoResponse|bool
     */
    public function getPaymentInfo($getPaymentInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->getPaymentInfo($getPaymentInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicyQRCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPolicyQRCode $getPolicyQRCode
     * @return getPolicyQRCodeResponse|bool
     */
    public function getPolicyQRCode($getPolicyQRCode)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicyQRCode($getPolicyQRCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDraftRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getDraftRequest $getDraftRequest
     * @return getDraftRequestResponse|bool
     */
    public function getDraftRequest($getDraftRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->getDraftRequest($getDraftRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDraftRequestForPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getDraftRequestForPrint $getDraftRequestForPrint
     * @return getDraftRequestForPrintResponse|bool
     */
    public function getDraftRequestForPrint($getDraftRequestForPrint)
    {
        try {
            $this->setResult($this->getSoapClient()->getDraftRequestForPrint($getDraftRequestForPrint));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOilByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getOilByKeyFields $getOilByKeyFields
     * @return getOilByKeyFieldsResponse|bool
     */
    public function getOilByKeyFields($getOilByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getOilByKeyFields($getOilByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOilQR
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getOilQR $getOilQR
     * @return getOilQRResponse|bool
     */
    public function getOilQR($getOilQR)
    {
        try {
            $this->setResult($this->getSoapClient()->getOilQR($getOilQR));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTechInspByKeyFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getTechInspByKeyFields $getTechInspByKeyFields
     * @return getTechInspByKeyFieldsResponse|bool
     */
    public function getTechInspByKeyFields($getTechInspByKeyFields)
    {
        try {
            $this->setResult($this->getSoapClient()->getTechInspByKeyFields($getTechInspByKeyFields));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param getPolicy $getPolicy
     * @return getPolicyResponse|bool
     */
    public function getPolicy($getPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicy($getPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return getAgentByKeyFieldsResponse|getArchiveByKeyFieldsResponse|getArchivePolicyDetailsResponse|getAvailableReportsResponse|getBillByKeyFieldsResponse|getBlankByKeyFieldsResponse|getBlankOrdersResponse|getBlankPrefixesResponse|getBlanksNumbersByIINResponse|getBlanksNumbersResponse|getBoxByKeyFieldsResponse|getBoxesResponse|getBoxIdByNumberResponse|getBoxPaymentResponse|getBoxPremiumByIINResponse|getBoxPremiumResponse|getBoxStatusResponse|getCallListResponse|getCarByNumberResponse|getCarInfoResponse|getCarShortResponse|getCarViolationsResponse|getClaimByKeyFieldsResponse|getClaimByPeriodResponse|getClaimSiteViewResponse|getClientClassByIINResponse|getClientClassByKeyFieldsResponse|getClientClassByManIDResponse|getClientClassResponse|getConfirmListResponse|getCurrencyRateResponse|getDictionaryResponse|getDocumentAttachmentResponse|getDraftRequestForPrintResponse|getDraftRequestResponse|getGuidBankResponse|getHalykTravelByKeyFieldsResponse|getInsrTypeCoverInfoResponse|getLimitConditionsResponse|getMarkTSResponse|getNameByIINResponse|getObjectCarByKeyFieldsResponse|getObjectCargoByKeyFieldsResponse|getObjectPropertyResponse|getOGPOFlagsByIINResponse|getOilByKeyFieldsResponse|getOilQRResponse|getOnlineCoverResponse|getOnlinePoliciesResponse|getPaymentInfoResponse|getPeopleByKeyFieldsResponse|getPeopleShortResponse|getPoliciesByKeyFieldsResponse|getPoliciesForPaymentByKeyFieldsResponse|getPolicyAppsResponse|getPolicyIDbyRefResponse|getPolicyPaidPremiumResponse|getPolicyPrintResponse|getPolicyQRCodeResponse|getPolicyResponse|getPremForSiteResponse|getPremiumAndInsNameResponse|getPremiumOGPOAutoByIINResponse|getPremiumOGPOAutoResponse|getPremiumTravelPolicyResponse|getPrintFormResponse|getReportParamsResponse|getReportResponse|getRZNUByManResponse|getSiebelBoxPaymentResponse|getSiebelBoxResponse|getSouvenirsResponse|getStaffByKeyFieldsResponse|getStandartCoversResponse|getStandartCoverValuesResponse|getStandartMultiCoverValuesResponse|getStandartRiskValuesResponse|getTariffListResponse|getTechInspByKeyFieldsResponse|getVerifiedPeopleResponse|getVierifiedPeopleByKeyFieldsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
