<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param deleteBill $deleteBill
     * @return deleteBillResponse|bool
     */
    public function deleteBill($deleteBill)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteBill($deleteBill));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteDocumentAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param deleteDocumentAttachment $deleteDocumentAttachment
     * @return deleteDocumentAttachmentResponse|bool
     */
    public function deleteDocumentAttachment($deleteDocumentAttachment)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteDocumentAttachment($deleteDocumentAttachment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param deleteArchive $deleteArchive
     * @return deleteArchiveResponse|bool
     */
    public function deleteArchive($deleteArchive)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteArchive($deleteArchive));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return deleteArchiveResponse|deleteBillResponse|deleteDocumentAttachmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
