<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named checkVerifiedStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkVerifiedStatus $checkVerifiedStatus
     * @return checkVerifiedStatusResponse|bool
     */
    public function checkVerifiedStatus($checkVerifiedStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->checkVerifiedStatus($checkVerifiedStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkFormats
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkFormats $checkFormats
     * @return checkFormatsResponse|bool
     */
    public function checkFormats($checkFormats)
    {
        try {
            $this->setResult($this->getSoapClient()->checkFormats($checkFormats));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPolicyExistence
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkPolicyExistence $checkPolicyExistence
     * @return checkPolicyExistenceResponse|bool
     */
    public function checkPolicyExistence($checkPolicyExistence)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPolicyExistence($checkPolicyExistence));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkOnlineStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkOnlineStatus $checkOnlineStatus
     * @return checkOnlineStatusResponse|bool
     */
    public function checkOnlineStatus($checkOnlineStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->checkOnlineStatus($checkOnlineStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkSiebelBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkSiebelBox $checkSiebelBox
     * @return checkSiebelBoxResponse|bool
     */
    public function checkSiebelBox($checkSiebelBox)
    {
        try {
            $this->setResult($this->getSoapClient()->checkSiebelBox($checkSiebelBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPKOState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkPKOState $checkPKOState
     * @return checkPKOStateResponse|bool
     */
    public function checkPKOState($checkPKOState)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPKOState($checkPKOState));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkObjectCar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkObjectCar $checkObjectCar
     * @return checkObjectCarResponse|bool
     */
    public function checkObjectCar($checkObjectCar)
    {
        try {
            $this->setResult($this->getSoapClient()->checkObjectCar($checkObjectCar));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkForClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkForClient $checkForClient
     * @return checkForClientResponse|bool
     */
    public function checkForClient($checkForClient)
    {
        try {
            $this->setResult($this->getSoapClient()->checkForClient($checkForClient));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPeopleIIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkPeopleIIN $checkPeopleIIN
     * @return checkPeopleIINResponse|bool
     */
    public function checkPeopleIIN($checkPeopleIIN)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPeopleIIN($checkPeopleIIN));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPeopleInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkPeopleInfo $checkPeopleInfo
     * @return checkPeopleInfoResponse|bool
     */
    public function checkPeopleInfo($checkPeopleInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPeopleInfo($checkPeopleInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named checkPolicyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param checkPolicyStatus $checkPolicyStatus
     * @return checkPolicyStatusResponse|bool
     */
    public function checkPolicyStatus($checkPolicyStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->checkPolicyStatus($checkPolicyStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return checkForClientResponse|checkFormatsResponse|checkObjectCarResponse|checkOnlineStatusResponse|checkPeopleIINResponse|checkPeopleInfoResponse|checkPKOStateResponse|checkPolicyExistenceResponse|checkPolicyStatusResponse|checkSiebelBoxResponse|checkVerifiedStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
