<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named changeBlankStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param changeBlankStatus $changeBlankStatus
     * @return changeBlankStatusResponse|bool
     */
    public function changeBlankStatus($changeBlankStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->changeBlankStatus($changeBlankStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return changeBlankStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
