<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calc ServiceType
 * @subpackage Services
 */
class Calc extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named calcOsgpoAutoCalendar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcOsgpoAutoCalendar $calcOsgpoAutoCalendar
     * @return calcOsgpoAutoCalendarResponse|bool
     */
    public function calcOsgpoAutoCalendar($calcOsgpoAutoCalendar)
    {
        try {
            $this->setResult($this->getSoapClient()->calcOsgpoAutoCalendar($calcOsgpoAutoCalendar));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcMst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcMst $calcMst
     * @return calcMstResponse|bool
     */
    public function calcMst($calcMst)
    {
        try {
            $this->setResult($this->getSoapClient()->calcMst($calcMst));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcOp_onai
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcOp_onai $calcOp_onai
     * @return calcOp_onaiResponse|bool
     */
    public function calcOp_onai($calcOp_onai)
    {
        try {
            $this->setResult($this->getSoapClient()->calcOp_onai($calcOp_onai));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcCascoClassic
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcCascoClassic $calcCascoClassic
     * @return calcCascoClassicResponse|bool
     */
    public function calcCascoClassic($calcCascoClassic)
    {
        try {
            $this->setResult($this->getSoapClient()->calcCascoClassic($calcCascoClassic));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcCascoAvangard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcCascoAvangard $calcCascoAvangard
     * @return calcCascoAvangardResponse|bool
     */
    public function calcCascoAvangard($calcCascoAvangard)
    {
        try {
            $this->setResult($this->getSoapClient()->calcCascoAvangard($calcCascoAvangard));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcCascoEleganse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcCascoEleganse $calcCascoEleganse
     * @return calcCascoEleganseResponse|bool
     */
    public function calcCascoEleganse($calcCascoEleganse)
    {
        try {
            $this->setResult($this->getSoapClient()->calcCascoEleganse($calcCascoEleganse));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcOsgpoAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param calcOsgpoAuto $calcOsgpoAuto
     * @return calcOsgpoAutoResponse|bool
     */
    public function calcOsgpoAuto($calcOsgpoAuto)
    {
        try {
            $this->setResult($this->getSoapClient()->calcOsgpoAuto($calcOsgpoAuto));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return calcCascoAvangardResponse|calcCascoClassicResponse|calcCascoEleganseResponse|calcMstResponse|calcOp_onaiResponse|calcOsgpoAutoCalendarResponse|calcOsgpoAutoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
