<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Annul ServiceType
 * @subpackage Services
 */
class Annul extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named annulBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param annulBox $annulBox
     * @return annulBoxResponse|bool
     */
    public function annulBox($annulBox)
    {
        try {
            $this->setResult($this->getSoapClient()->annulBox($annulBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param annulApplication $annulApplication
     * @return annulApplicationResponse|bool
     */
    public function annulApplication($annulApplication)
    {
        try {
            $this->setResult($this->getSoapClient()->annulApplication($annulApplication));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulOilCoupon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param annulOilCoupon $annulOilCoupon
     * @return annulOilCouponResponse|bool
     */
    public function annulOilCoupon($annulOilCoupon)
    {
        try {
            $this->setResult($this->getSoapClient()->annulOilCoupon($annulOilCoupon));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulTechInspection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param annulTechInspection $annulTechInspection
     * @return annulTechInspectionResponse|bool
     */
    public function annulTechInspection($annulTechInspection)
    {
        try {
            $this->setResult($this->getSoapClient()->annulTechInspection($annulTechInspection));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return annulApplicationResponse|annulBoxResponse|annulOilCouponResponse|annulTechInspectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
