<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addSiebelBoxFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param addSiebelBoxFile $addSiebelBoxFile
     * @return addSiebelBoxFileResponse|bool
     */
    public function addSiebelBoxFile($addSiebelBoxFile)
    {
        try {
            $this->setResult($this->getSoapClient()->addSiebelBoxFile($addSiebelBoxFile));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return addSiebelBoxFileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
