<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Activate ServiceType
 * @subpackage Services
 */
class Activate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named activateBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param activateBox $activateBox
     * @return activateBoxResponse|bool
     */
    public function activateBox($activateBox)
    {
        try {
            $this->setResult($this->getSoapClient()->activateBox($activateBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return activateBoxResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
