<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Use ServiceType
 * @subpackage Services
 */
class _Use extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named useDistribution
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param useDistribution $useDistribution
     * @return useDistributionResponse|bool
     */
    public function useDistribution($useDistribution)
    {
        try {
            $this->setResult($this->getSoapClient()->useDistribution($useDistribution));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return useDistributionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
