<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setArchive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setArchive $setArchive
     * @return setArchiveResponse|bool
     */
    public function setArchive($setArchive)
    {
        try {
            $this->setResult($this->getSoapClient()->setArchive($setArchive));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCallCenterSale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setCallCenterSale $setCallCenterSale
     * @return setCallCenterSaleResponse|bool
     */
    public function setCallCenterSale($setCallCenterSale)
    {
        try {
            $this->setResult($this->getSoapClient()->setCallCenterSale($setCallCenterSale));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setHalykTravel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setHalykTravel $setHalykTravel
     * @return setHalykTravelResponse|bool
     */
    public function setHalykTravel($setHalykTravel)
    {
        try {
            $this->setResult($this->getSoapClient()->setHalykTravel($setHalykTravel));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setHalykTravelPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setHalykTravelPayment $setHalykTravelPayment
     * @return setHalykTravelPaymentResponse|bool
     */
    public function setHalykTravelPayment($setHalykTravelPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->setHalykTravelPayment($setHalykTravelPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPolicyOGPOAuto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPolicyOGPOAuto $setPolicyOGPOAuto
     * @return setPolicyOGPOAutoResponse|bool
     */
    public function setPolicyOGPOAuto($setPolicyOGPOAuto)
    {
        try {
            $this->setResult($this->getSoapClient()->setPolicyOGPOAuto($setPolicyOGPOAuto));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setErrorText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setErrorText $setErrorText
     * @return setErrorTextResponse|bool
     */
    public function setErrorText($setErrorText)
    {
        try {
            $this->setResult($this->getSoapClient()->setErrorText($setErrorText));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPaymentReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPaymentReference $setPaymentReference
     * @return setPaymentReferenceResponse|bool
     */
    public function setPaymentReference($setPaymentReference)
    {
        try {
            $this->setResult($this->getSoapClient()->setPaymentReference($setPaymentReference));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setTravelPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setTravelPolicy $setTravelPolicy
     * @return setTravelPolicyResponse|bool
     */
    public function setTravelPolicy($setTravelPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->setTravelPolicy($setTravelPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setBoxPayment $setBoxPayment
     * @return setBoxPaymentResponse|bool
     */
    public function setBoxPayment($setBoxPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxPayment($setBoxPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setBoxPayments $setBoxPayments
     * @return setBoxPaymentsResponse|bool
     */
    public function setBoxPayments($setBoxPayments)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxPayments($setBoxPayments));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setBoxAddress $setBoxAddress
     * @return setBoxAddressResponse|bool
     */
    public function setBoxAddress($setBoxAddress)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxAddress($setBoxAddress));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBoxAddressKATO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setBoxAddressKATO $setBoxAddressKATO
     * @return setBoxAddressKATOResponse|bool
     */
    public function setBoxAddressKATO($setBoxAddressKATO)
    {
        try {
            $this->setResult($this->getSoapClient()->setBoxAddressKATO($setBoxAddressKATO));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setSiebelPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setSiebelPolicy $setSiebelPolicy
     * @return setSiebelPolicyResponse|bool
     */
    public function setSiebelPolicy($setSiebelPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->setSiebelPolicy($setSiebelPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setSiebelBoxPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setSiebelBoxPayment $setSiebelBoxPayment
     * @return setSiebelBoxPaymentResponse|bool
     */
    public function setSiebelBoxPayment($setSiebelBoxPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->setSiebelBoxPayment($setSiebelBoxPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setSiebelHBCardInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setSiebelHBCardInfo $setSiebelHBCardInfo
     * @return setSiebelHBCardInfoResponse|bool
     */
    public function setSiebelHBCardInfo($setSiebelHBCardInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->setSiebelHBCardInfo($setSiebelHBCardInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setCash
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setCash $setCash
     * @return setCashResponse|bool
     */
    public function setCash($setCash)
    {
        try {
            $this->setResult($this->getSoapClient()->setCash($setCash));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPayment $setPayment
     * @return setPaymentResponse|bool
     */
    public function setPayment($setPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->setPayment($setPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setObjectCar $setObjectCar
     * @return setObjectCarResponse|bool
     */
    public function setObjectCar($setObjectCar)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCar($setObjectCar));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCarAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setObjectCarAttachment $setObjectCarAttachment
     * @return setObjectCarAttachmentResponse|bool
     */
    public function setObjectCarAttachment($setObjectCarAttachment)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCarAttachment($setObjectCarAttachment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setBlanks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setBlanks $setBlanks
     * @return setBlanksResponse|bool
     */
    public function setBlanks($setBlanks)
    {
        try {
            $this->setResult($this->getSoapClient()->setBlanks($setBlanks));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setAMEXPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setAMEXPolicy $setAMEXPolicy
     * @return setAMEXPolicyResponse|bool
     */
    public function setAMEXPolicy($setAMEXPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->setAMEXPolicy($setAMEXPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setOSRNSDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setOSRNSDetails $setOSRNSDetails
     * @return setOSRNSDetailsResponse|bool
     */
    public function setOSRNSDetails($setOSRNSDetails)
    {
        try {
            $this->setResult($this->getSoapClient()->setOSRNSDetails($setOSRNSDetails));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPolicyAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPolicyAttachment $setPolicyAttachment
     * @return setPolicyAttachmentResponse|bool
     */
    public function setPolicyAttachment($setPolicyAttachment)
    {
        try {
            $this->setResult($this->getSoapClient()->setPolicyAttachment($setPolicyAttachment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPaymentSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPaymentSite $setPaymentSite
     * @return setPaymentSiteResponse|bool
     */
    public function setPaymentSite($setPaymentSite)
    {
        try {
            $this->setResult($this->getSoapClient()->setPaymentSite($setPaymentSite));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setIncomingReinsurance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setIncomingReinsurance $setIncomingReinsurance
     * @return setIncomingReinsuranceResponse|bool
     */
    public function setIncomingReinsurance($setIncomingReinsurance)
    {
        try {
            $this->setResult($this->getSoapClient()->setIncomingReinsurance($setIncomingReinsurance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setArchiveConfirm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setArchiveConfirm $setArchiveConfirm
     * @return setArchiveConfirmResponse|bool
     */
    public function setArchiveConfirm($setArchiveConfirm)
    {
        try {
            $this->setResult($this->getSoapClient()->setArchiveConfirm($setArchiveConfirm));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectLiability
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setObjectLiability $setObjectLiability
     * @return setObjectLiabilityResponse|bool
     */
    public function setObjectLiability($setObjectLiability)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectLiability($setObjectLiability));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCustom
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setObjectCustom $setObjectCustom
     * @return setObjectCustomResponse|bool
     */
    public function setObjectCustom($setObjectCustom)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCustom($setObjectCustom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectProperty
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setObjectProperty $setObjectProperty
     * @return setObjectPropertyResponse|bool
     */
    public function setObjectProperty($setObjectProperty)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectProperty($setObjectProperty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setObjectCargo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setObjectCargo $setObjectCargo
     * @return setObjectCargoResponse|bool
     */
    public function setObjectCargo($setObjectCargo)
    {
        try {
            $this->setResult($this->getSoapClient()->setObjectCargo($setObjectCargo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPeople $setPeople
     * @return setPeopleResponse|bool
     */
    public function setPeople($setPeople)
    {
        try {
            $this->setResult($this->getSoapClient()->setPeople($setPeople));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setVerifiedPeople
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setVerifiedPeople $setVerifiedPeople
     * @return setVerifiedPeopleResponse|bool
     */
    public function setVerifiedPeople($setVerifiedPeople)
    {
        try {
            $this->setResult($this->getSoapClient()->setVerifiedPeople($setVerifiedPeople));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRequestDataFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setRequestDataFile $setRequestDataFile
     * @return setRequestDataFileResponse|bool
     */
    public function setRequestDataFile($setRequestDataFile)
    {
        try {
            $this->setResult($this->getSoapClient()->setRequestDataFile($setRequestDataFile));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setRequestData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setRequestData $setRequestData
     * @return setRequestDataResponse|bool
     */
    public function setRequestData($setRequestData)
    {
        try {
            $this->setResult($this->getSoapClient()->setRequestData($setRequestData));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setPolicy $setPolicy
     * @return setPolicyResponse|bool
     */
    public function setPolicy($setPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->setPolicy($setPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param setApplication $setApplication
     * @return setApplicationResponse|bool
     */
    public function setApplication($setApplication)
    {
        try {
            $this->setResult($this->getSoapClient()->setApplication($setApplication));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return setAMEXPolicyResponse|setApplicationResponse|setArchiveConfirmResponse|setArchiveResponse|setBlanksResponse|setBoxAddressKATOResponse|setBoxAddressResponse|setBoxPaymentResponse|setBoxPaymentsResponse|setCallCenterSaleResponse|setCashResponse|setErrorTextResponse|setHalykTravelPaymentResponse|setHalykTravelResponse|setIncomingReinsuranceResponse|setObjectCarAttachmentResponse|setObjectCargoResponse|setObjectCarResponse|setObjectCustomResponse|setObjectLiabilityResponse|setObjectPropertyResponse|setOSRNSDetailsResponse|setPaymentReferenceResponse|setPaymentResponse|setPaymentSiteResponse|setPeopleResponse|setPolicyAttachmentResponse|setPolicyOGPOAutoResponse|setPolicyResponse|setRequestDataFileResponse|setRequestDataResponse|setSiebelBoxPaymentResponse|setSiebelHBCardInfoResponse|setSiebelPolicyResponse|setTravelPolicyResponse|setVerifiedPeopleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
