<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sendPrintFormToEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param sendPrintFormToEmail $sendPrintFormToEmail
     * @return sendPrintFormToEmailResponse|bool
     */
    public function sendPrintFormToEmail($sendPrintFormToEmail)
    {
        try {
            $this->setResult($this->getSoapClient()->sendPrintFormToEmail($sendPrintFormToEmail));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendPrintFormToEmailIPTest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param sendPrintFormToEmailIPTest $sendPrintFormToEmailIPTest
     * @return sendPrintFormToEmailIPTestResponse|bool
     */
    public function sendPrintFormToEmailIPTest($sendPrintFormToEmailIPTest)
    {
        try {
            $this->setResult($this->getSoapClient()->sendPrintFormToEmailIPTest($sendPrintFormToEmailIPTest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendTestMailForMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param sendTestMailForMe $sendTestMailForMe
     * @return sendTestMailForMeResponse|bool
     */
    public function sendTestMailForMe($sendTestMailForMe)
    {
        try {
            $this->setResult($this->getSoapClient()->sendTestMailForMe($sendTestMailForMe));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSmsOil
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param sendSmsOil $sendSmsOil
     * @return sendSmsOilResponse|bool
     */
    public function sendSmsOil($sendSmsOil)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSmsOil($sendSmsOil));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sendSmsTechInspection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param sendSmsTechInspection $sendSmsTechInspection
     * @return sendSmsTechInspectionResponse|bool
     */
    public function sendSmsTechInspection($sendSmsTechInspection)
    {
        try {
            $this->setResult($this->getSoapClient()->sendSmsTechInspection($sendSmsTechInspection));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return sendPrintFormToEmailIPTestResponse|sendPrintFormToEmailResponse|sendSmsOilResponse|sendSmsTechInspectionResponse|sendTestMailForMeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
