<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Renewal ServiceType
 * @subpackage Services
 */
class Renewal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named renewalPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param renewalPolicy $renewalPolicy
     * @return renewalPolicyResponse|bool
     */
    public function renewalPolicy($renewalPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->renewalPolicy($renewalPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return renewalPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
