<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named markPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param markPayment $markPayment
     * @return markPaymentResponse|bool
     */
    public function markPayment($markPayment)
    {
        try {
            $this->setResult($this->getSoapClient()->markPayment($markPayment));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named markPaymentTerminal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param markPaymentTerminal $markPaymentTerminal
     * @return markPaymentTerminalResponse|bool
     */
    public function markPaymentTerminal($markPaymentTerminal)
    {
        try {
            $this->setResult($this->getSoapClient()->markPaymentTerminal($markPaymentTerminal));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return markPaymentResponse|markPaymentTerminalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
