<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createSiebelBox
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param createSiebelBox $createSiebelBox
     * @return createSiebelBoxResponse|bool
     */
    public function createSiebelBox($createSiebelBox)
    {
        try {
            $this->setResult($this->getSoapClient()->createSiebelBox($createSiebelBox));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createBill
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param createBill $createBill
     * @return createBillResponse|bool
     */
    public function createBill($createBill)
    {
        try {
            $this->setResult($this->getSoapClient()->createBill($createBill));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return createBillResponse|createSiebelBoxResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
