<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clean ServiceType
 * @subpackage Services
 */
class Clean extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cleanQueue
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param cleanQueue $cleanQueue
     * @return cleanQueueResponse|bool
     */
    public function cleanQueue($cleanQueue)
    {
        try {
            $this->setResult($this->getSoapClient()->cleanQueue($cleanQueue));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return cleanQueueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
