<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Active ServiceType
 * @subpackage Services
 */
class Active extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named activeTechInspection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param activeTechInspection $activeTechInspection
     * @return activeTechInspectionResponse|bool
     */
    public function activeTechInspection($activeTechInspection)
    {
        try {
            $this->setResult($this->getSoapClient()->activeTechInspection($activeTechInspection));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return activeTechInspectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
