<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for APIT ServiceType
 * @subpackage Services
 */
class APIT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named APITest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param APITest $aPITest
     * @return APITestResponse|bool
     */
    public function APITest($aPITest)
    {
        try {
            $this->setResult($this->getSoapClient()->APITest($aPITest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return APITestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
