<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatedItemInfo StructType
 * @subpackage Structs
 */
class UpdatedItemInfo extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The RowVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowVersion;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ItemType;
    /**
     * Constructor method for UpdatedItemInfo
     * @uses UpdatedItemInfo::setId()
     * @uses UpdatedItemInfo::setRowVersion()
     * @uses UpdatedItemInfo::setItemType()
     * @param int $id
     * @param int $rowVersion
     * @param string $itemType
     */
    public function __construct($id = null, $rowVersion = null, $itemType = null)
    {
        $this
            ->setId($id)
            ->setRowVersion($rowVersion)
            ->setItemType($itemType);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\UpdatedItemInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RowVersion value
     * @return int
     */
    public function getRowVersion()
    {
        return $this->RowVersion;
    }
    /**
     * Set RowVersion value
     * @param int $rowVersion
     * @return \StructType\UpdatedItemInfo
     */
    public function setRowVersion($rowVersion = null)
    {
        // validation for constraint: int
        if (!is_null($rowVersion) && !(is_int($rowVersion) || ctype_digit($rowVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowVersion, true), gettype($rowVersion)), __LINE__);
        }
        $this->RowVersion = $rowVersion;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\UpdatedItemInfo
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemType', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
}
