<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopSettingsData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShopSettingsData
 * @subpackage Structs
 */
class ShopSettingsData extends AbstractStructBase
{
    /**
     * The ShowGalleryMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowGalleryMode;
    /**
     * The ShowAuctionView
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowAuctionView;
    /**
     * The IsTemporaryClosed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsTemporaryClosed;
    /**
     * The MaxActiveItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxActiveItems;
    /**
     * The MaxInventoryItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxInventoryItems;
    /**
     * The CompanyInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyInformation;
    /**
     * The PurchaseTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseTerms;
    /**
     * The LogoInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShopLogoData
     */
    public $LogoInformation;
    /**
     * The BannerColor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BannerColor;
    /**
     * The TemporaryClosedMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemporaryClosedMessage;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInformation;
    /**
     * The LogoImageUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LogoImageUrl;
    /**
     * Constructor method for ShopSettingsData
     * @uses ShopSettingsData::setShowGalleryMode()
     * @uses ShopSettingsData::setShowAuctionView()
     * @uses ShopSettingsData::setIsTemporaryClosed()
     * @uses ShopSettingsData::setMaxActiveItems()
     * @uses ShopSettingsData::setMaxInventoryItems()
     * @uses ShopSettingsData::setCompanyInformation()
     * @uses ShopSettingsData::setPurchaseTerms()
     * @uses ShopSettingsData::setLogoInformation()
     * @uses ShopSettingsData::setBannerColor()
     * @uses ShopSettingsData::setTemporaryClosedMessage()
     * @uses ShopSettingsData::setContactInformation()
     * @uses ShopSettingsData::setLogoImageUrl()
     * @param bool $showGalleryMode
     * @param bool $showAuctionView
     * @param bool $isTemporaryClosed
     * @param int $maxActiveItems
     * @param int $maxInventoryItems
     * @param string $companyInformation
     * @param string $purchaseTerms
     * @param \StructType\ShopLogoData $logoInformation
     * @param string $bannerColor
     * @param string $temporaryClosedMessage
     * @param string $contactInformation
     * @param string $logoImageUrl
     */
    public function __construct($showGalleryMode = null, $showAuctionView = null, $isTemporaryClosed = null, $maxActiveItems = null, $maxInventoryItems = null, $companyInformation = null, $purchaseTerms = null, \StructType\ShopLogoData $logoInformation = null, $bannerColor = null, $temporaryClosedMessage = null, $contactInformation = null, $logoImageUrl = null)
    {
        $this
            ->setShowGalleryMode($showGalleryMode)
            ->setShowAuctionView($showAuctionView)
            ->setIsTemporaryClosed($isTemporaryClosed)
            ->setMaxActiveItems($maxActiveItems)
            ->setMaxInventoryItems($maxInventoryItems)
            ->setCompanyInformation($companyInformation)
            ->setPurchaseTerms($purchaseTerms)
            ->setLogoInformation($logoInformation)
            ->setBannerColor($bannerColor)
            ->setTemporaryClosedMessage($temporaryClosedMessage)
            ->setContactInformation($contactInformation)
            ->setLogoImageUrl($logoImageUrl);
    }
    /**
     * Get ShowGalleryMode value
     * @return bool
     */
    public function getShowGalleryMode()
    {
        return $this->ShowGalleryMode;
    }
    /**
     * Set ShowGalleryMode value
     * @param bool $showGalleryMode
     * @return \StructType\ShopSettingsData
     */
    public function setShowGalleryMode($showGalleryMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($showGalleryMode) && !is_bool($showGalleryMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showGalleryMode, true), gettype($showGalleryMode)), __LINE__);
        }
        $this->ShowGalleryMode = $showGalleryMode;
        return $this;
    }
    /**
     * Get ShowAuctionView value
     * @return bool
     */
    public function getShowAuctionView()
    {
        return $this->ShowAuctionView;
    }
    /**
     * Set ShowAuctionView value
     * @param bool $showAuctionView
     * @return \StructType\ShopSettingsData
     */
    public function setShowAuctionView($showAuctionView = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAuctionView) && !is_bool($showAuctionView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAuctionView, true), gettype($showAuctionView)), __LINE__);
        }
        $this->ShowAuctionView = $showAuctionView;
        return $this;
    }
    /**
     * Get IsTemporaryClosed value
     * @return bool
     */
    public function getIsTemporaryClosed()
    {
        return $this->IsTemporaryClosed;
    }
    /**
     * Set IsTemporaryClosed value
     * @param bool $isTemporaryClosed
     * @return \StructType\ShopSettingsData
     */
    public function setIsTemporaryClosed($isTemporaryClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTemporaryClosed) && !is_bool($isTemporaryClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTemporaryClosed, true), gettype($isTemporaryClosed)), __LINE__);
        }
        $this->IsTemporaryClosed = $isTemporaryClosed;
        return $this;
    }
    /**
     * Get MaxActiveItems value
     * @return int
     */
    public function getMaxActiveItems()
    {
        return $this->MaxActiveItems;
    }
    /**
     * Set MaxActiveItems value
     * @param int $maxActiveItems
     * @return \StructType\ShopSettingsData
     */
    public function setMaxActiveItems($maxActiveItems = null)
    {
        // validation for constraint: int
        if (!is_null($maxActiveItems) && !(is_int($maxActiveItems) || ctype_digit($maxActiveItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxActiveItems, true), gettype($maxActiveItems)), __LINE__);
        }
        $this->MaxActiveItems = $maxActiveItems;
        return $this;
    }
    /**
     * Get MaxInventoryItems value
     * @return int
     */
    public function getMaxInventoryItems()
    {
        return $this->MaxInventoryItems;
    }
    /**
     * Set MaxInventoryItems value
     * @param int $maxInventoryItems
     * @return \StructType\ShopSettingsData
     */
    public function setMaxInventoryItems($maxInventoryItems = null)
    {
        // validation for constraint: int
        if (!is_null($maxInventoryItems) && !(is_int($maxInventoryItems) || ctype_digit($maxInventoryItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxInventoryItems, true), gettype($maxInventoryItems)), __LINE__);
        }
        $this->MaxInventoryItems = $maxInventoryItems;
        return $this;
    }
    /**
     * Get CompanyInformation value
     * @return string|null
     */
    public function getCompanyInformation()
    {
        return $this->CompanyInformation;
    }
    /**
     * Set CompanyInformation value
     * @param string $companyInformation
     * @return \StructType\ShopSettingsData
     */
    public function setCompanyInformation($companyInformation = null)
    {
        // validation for constraint: string
        if (!is_null($companyInformation) && !is_string($companyInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyInformation, true), gettype($companyInformation)), __LINE__);
        }
        $this->CompanyInformation = $companyInformation;
        return $this;
    }
    /**
     * Get PurchaseTerms value
     * @return string|null
     */
    public function getPurchaseTerms()
    {
        return $this->PurchaseTerms;
    }
    /**
     * Set PurchaseTerms value
     * @param string $purchaseTerms
     * @return \StructType\ShopSettingsData
     */
    public function setPurchaseTerms($purchaseTerms = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseTerms) && !is_string($purchaseTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseTerms, true), gettype($purchaseTerms)), __LINE__);
        }
        $this->PurchaseTerms = $purchaseTerms;
        return $this;
    }
    /**
     * Get LogoInformation value
     * @return \StructType\ShopLogoData|null
     */
    public function getLogoInformation()
    {
        return $this->LogoInformation;
    }
    /**
     * Set LogoInformation value
     * @param \StructType\ShopLogoData $logoInformation
     * @return \StructType\ShopSettingsData
     */
    public function setLogoInformation(\StructType\ShopLogoData $logoInformation = null)
    {
        $this->LogoInformation = $logoInformation;
        return $this;
    }
    /**
     * Get BannerColor value
     * @return string|null
     */
    public function getBannerColor()
    {
        return $this->BannerColor;
    }
    /**
     * Set BannerColor value
     * @param string $bannerColor
     * @return \StructType\ShopSettingsData
     */
    public function setBannerColor($bannerColor = null)
    {
        // validation for constraint: string
        if (!is_null($bannerColor) && !is_string($bannerColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bannerColor, true), gettype($bannerColor)), __LINE__);
        }
        $this->BannerColor = $bannerColor;
        return $this;
    }
    /**
     * Get TemporaryClosedMessage value
     * @return string|null
     */
    public function getTemporaryClosedMessage()
    {
        return $this->TemporaryClosedMessage;
    }
    /**
     * Set TemporaryClosedMessage value
     * @param string $temporaryClosedMessage
     * @return \StructType\ShopSettingsData
     */
    public function setTemporaryClosedMessage($temporaryClosedMessage = null)
    {
        // validation for constraint: string
        if (!is_null($temporaryClosedMessage) && !is_string($temporaryClosedMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($temporaryClosedMessage, true), gettype($temporaryClosedMessage)), __LINE__);
        }
        $this->TemporaryClosedMessage = $temporaryClosedMessage;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return string|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * Set ContactInformation value
     * @param string $contactInformation
     * @return \StructType\ShopSettingsData
     */
    public function setContactInformation($contactInformation = null)
    {
        // validation for constraint: string
        if (!is_null($contactInformation) && !is_string($contactInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInformation, true), gettype($contactInformation)), __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Get LogoImageUrl value
     * @return string|null
     */
    public function getLogoImageUrl()
    {
        return $this->LogoImageUrl;
    }
    /**
     * Set LogoImageUrl value
     * @param string $logoImageUrl
     * @return \StructType\ShopSettingsData
     */
    public function setLogoImageUrl($logoImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($logoImageUrl) && !is_string($logoImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logoImageUrl, true), gettype($logoImageUrl)), __LINE__);
        }
        $this->LogoImageUrl = $logoImageUrl;
        return $this;
    }
}
