<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShopItemVariantUpdateData StructType
 * @subpackage Structs
 */
class ShopItemVariantUpdateData extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The ItemData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShopItemVariantData
     */
    public $ItemData;
    /**
     * Constructor method for ShopItemVariantUpdateData
     * @uses ShopItemVariantUpdateData::setItemId()
     * @uses ShopItemVariantUpdateData::setItemData()
     * @param int $itemId
     * @param \StructType\ShopItemVariantData $itemData
     */
    public function __construct($itemId = null, \StructType\ShopItemVariantData $itemData = null)
    {
        $this
            ->setItemId($itemId)
            ->setItemData($itemData);
    }
    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\ShopItemVariantUpdateData
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemData value
     * @return \StructType\ShopItemVariantData|null
     */
    public function getItemData()
    {
        return $this->ItemData;
    }
    /**
     * Set ItemData value
     * @param \StructType\ShopItemVariantData $itemData
     * @return \StructType\ShopItemVariantUpdateData
     */
    public function setItemData(\StructType\ShopItemVariantData $itemData = null)
    {
        $this->ItemData = $itemData;
        return $this;
    }
}
