<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeaveOrderFeedbackToBuyer StructType
 * @subpackage Structs
 */
class LeaveOrderFeedbackToBuyer extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderNumber;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for LeaveOrderFeedbackToBuyer
     * @uses LeaveOrderFeedbackToBuyer::setOrderNumber()
     * @uses LeaveOrderFeedbackToBuyer::setType()
     * @uses LeaveOrderFeedbackToBuyer::setComment()
     * @param int $orderNumber
     * @param string $type
     * @param string $comment
     */
    public function __construct($orderNumber = null, $type = null, $comment = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setType($type)
            ->setComment($comment);
    }
    /**
     * Get orderNumber value
     * @return int
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param int $orderNumber
     * @return \StructType\LeaveOrderFeedbackToBuyer
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\FeedbackType::valueIsValid()
     * @uses \EnumType\FeedbackType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\LeaveOrderFeedbackToBuyer
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FeedbackType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FeedbackType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\FeedbackType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\LeaveOrderFeedbackToBuyer
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
